/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public final class CertificateHostnameVerifier
implements HostnameVerifier {
    private static HashSet hashSet = new HashSet();

    public boolean verify(String string, SSLSession sSLSession) {
        Object[] objectArray;
        Object object;
        String string2 = ResourceManager.getMessage("https.dialog.unknown.host");
        try {
            int n;
            object = sSLSession.getPeerCertificates();
            if (!(object[0] instanceof X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            objectArray = (Object[])object[0];
            String string3 = objectArray.getSubjectDN().getName();
            if (string3 != null && (n = string3.toUpperCase().indexOf("CN=")) != -1) {
                int n2 = string3.indexOf(",", n);
                string2 = n2 != -1 ? string3.substring(n + 3, n2) : string3.substring(n + 3);
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        if (string.equalsIgnoreCase(string2) || string2.equals("*")) {
            return true;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            objectArray = (Object[])object.next();
            if (!objectArray[0].toString().equalsIgnoreCase(string) || !objectArray[1].toString().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return this.showHostnameMismatchDialog(string, string2);
    }

    private boolean showHostnameMismatchDialog(String string, String string2) {
        String string3 = ResourceManager.getMessage("https.dialog.caption");
        String string4 = ResourceManager.getMessage("https.dialog.masthead");
        AppInfo appInfo = new AppInfo(0, string, string2, null, null, null, false, false, null, null);
        String string5 = ResourceManager.getMessage("security.dialog.signed.buttonContinue");
        String string6 = ResourceManager.getMessage("security.dialog.signed.buttonCancel");
        int n = -1;
        MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("security.dialog.hostname.mismatch.sub"));
        Object[] objectArray = new Object[]{string, string2};
        String[] stringArray = new String[]{messageFormat.format(objectArray)};
        if (!Trace.isAutomationEnabled()) {
            n = Config.getBooleanProperty("deployment.security.jsse.hostmismatch.warning") ? UIFactory.showSecurityDialog(appInfo, string3, string4, string2, null, false, false, string5, string6, stringArray, null, false, null, -1, -1, false) : 0;
        } else {
            Trace.msgSecurityPrintln("hostnameverifier.automation.ignoremismatch");
            n = 0;
        }
        if (n == 0) {
            Object[] objectArray2 = new Object[]{string, string2};
            hashSet.add(objectArray2);
        }
        return n == 0;
    }

    public static void reset() {
        hashSet.clear();
    }
}

