/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.d3d;

import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import sun.awt.image.CachingSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.d3d.D3DGraphicsConfig;
import sun.java2d.d3d.D3DSurfaceData;
import sun.java2d.loops.CompositeType;

public class D3DCachingSurfaceManager
extends CachingSurfaceManager {
    private int transparency;

    public D3DCachingSurfaceManager(BufferedImage bufferedImage) {
        super(bufferedImage);
        this.transparency = bufferedImage.getColorModel().getTransparency();
        if (accelerationThreshold == 0 && this.localAccelerationEnabled) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedSurface(graphicsConfiguration, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
    }

    protected boolean isDestSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof D3DSurfaceData;
    }

    protected boolean isOperationSupported(SurfaceData surfaceData, CompositeType compositeType, Color color, boolean bl) {
        return surfaceData instanceof D3DSurfaceData && (color == null || this.transparency == 1);
    }

    protected SurfaceData createAccelSurface(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        if (graphicsConfiguration instanceof D3DGraphicsConfig) {
            return D3DSurfaceData.createData((D3DGraphicsConfig)graphicsConfiguration, n, n2, graphicsConfiguration.getColorModel(this.transparency), this.bImg, 3);
        }
        return null;
    }

    public String toString() {
        return new String("D3DCachingSurfaceManager@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }

    protected void restoreAcceleratedSurface() {
        if (this.sdAccel != null) {
            ((D3DSurfaceData)this.sdAccel).restoreSurface();
        }
    }
}

