/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.security.AccessController;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock = new Object();
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private static boolean changed = false;
    private static long lastRefresh = -1L;
    private static final int TIMEOUT = 120000;
    private static String os_searchlist;
    private static String os_nameservers;
    private static LinkedList searchlist;
    private static LinkedList nameservers;

    private LinkedList stringToList(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (linkedList.contains(string2)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    private void loadConfig() {
        long l;
        assert (Thread.holdsLock(lock));
        if (changed) {
            changed = false;
        } else if (lastRefresh >= 0L && (l = System.currentTimeMillis()) - lastRefresh < 120000L) {
            return;
        }
        ResolverConfigurationImpl.loadDNSconfig0();
        lastRefresh = System.currentTimeMillis();
        searchlist = this.stringToList(os_searchlist);
        nameservers = this.stringToList(os_nameservers);
        os_searchlist = null;
        os_nameservers = null;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)nameservers.clone();
        }
    }

    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native void init0();

    static native void loadDNSconfig0();

    static native int notifyAddrChange0();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        ResolverConfigurationImpl.init0();
        AddressChangeListener addressChangeListener = new AddressChangeListener();
        addressChangeListener.setDaemon(true);
        addressChangeListener.start();
    }

    static class AddressChangeListener
    extends Thread {
        AddressChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (ResolverConfigurationImpl.notifyAddrChange0() == 0) {
                Object object = lock;
                synchronized (object) {
                    changed = true;
                }
            }
            return;
        }
    }
}

