/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.xml;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.internal.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.api.streaming.XMLStreamWriterFactory;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.XMLHTTPBindingCodec;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.EmptyMessageImpl;
import com.sun.xml.internal.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class XMLMessage {
    private static final int PLAIN_XML_FLAG = 1;
    private static final int MIME_MULTIPART_FLAG = 2;
    private static final int FI_ENCODED_FLAG = 16;

    private static InputStream hasSomeData(InputStream inputStream) throws IOException {
        if (inputStream != null && inputStream.available() < 1) {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream);
            }
            inputStream.mark(1);
            if (inputStream.read() != -1) {
                inputStream.reset();
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }

    public static Message create(String string, InputStream inputStream) {
        Message message;
        try {
            com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType contentType;
            int n;
            inputStream = XMLMessage.hasSomeData(inputStream);
            if (inputStream == null) {
                Message message2 = Messages.createEmpty(SOAPVersion.SOAP_11);
                return message2;
            }
            message = string != null ? (((n = XMLMessage.identifyContentType(contentType = new com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType(string))) & 2) != 0 ? new XMLMultiPart(string, inputStream) : ((n & 1) != 0 ? Messages.createUsingPayload(new StreamSource(inputStream), SOAPVersion.SOAP_11) : new UnknownContent(string, inputStream))) : Messages.createEmpty(SOAPVersion.SOAP_11);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return message;
    }

    public static Message create(Source source) {
        return source == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : Messages.createUsingPayload(source, SOAPVersion.SOAP_11);
    }

    public static Message create(DataSource dataSource) {
        try {
            return dataSource == null ? Messages.createEmpty(SOAPVersion.SOAP_11) : XMLMessage.create(dataSource.getContentType(), dataSource.getInputStream());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public static Message create(Exception exception) {
        return new FaultMessage(SOAPVersion.SOAP_11);
    }

    private static int getContentId(String string) {
        try {
            com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType(string);
            return XMLMessage.identifyContentType(contentType);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    public static boolean isFastInfoset(String string) {
        return (XMLMessage.getContentId(string) & 0x10) != 0;
    }

    public static int identifyContentType(com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType contentType) {
        String string = contentType.getPrimaryType();
        String string2 = contentType.getSubType();
        if (string.equalsIgnoreCase("multipart") && string2.equalsIgnoreCase("related")) {
            String string3 = contentType.getParameter("type");
            if (string3 != null) {
                if (XMLMessage.isXMLType(string3)) {
                    return 3;
                }
                if (XMLMessage.isFastInfosetType(string3)) {
                    return 18;
                }
            }
            return 0;
        }
        if (XMLMessage.isXMLType(string, string2)) {
            return 1;
        }
        if (XMLMessage.isFastInfosetType(string, string2)) {
            return 16;
        }
        return 0;
    }

    protected static boolean isXMLType(@NotNull String string, @NotNull String string2) {
        return string.equalsIgnoreCase("text") && string2.equalsIgnoreCase("xml") || string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("xml") || string.equalsIgnoreCase("application") && string2.toLowerCase().endsWith("+xml");
    }

    protected static boolean isXMLType(String string) {
        String string2 = string.toLowerCase();
        return string2.startsWith("text/xml") || string2.startsWith("application/xml") || string2.startsWith("application/") && string2.indexOf("+xml") != -1;
    }

    protected static boolean isFastInfosetType(String string, String string2) {
        return string.equalsIgnoreCase("application") && string2.equalsIgnoreCase("fastinfoset");
    }

    protected static boolean isFastInfosetType(String string) {
        return string.toLowerCase().startsWith("application/fastinfoset");
    }

    public static DataSource getDataSource(Message message) {
        if (message instanceof MessageDataSource) {
            return ((MessageDataSource)((Object)message)).getDataSource();
        }
        AttachmentSet attachmentSet = message.getAttachments();
        if (attachmentSet != null && !attachmentSet.isEmpty()) {
            ByteOutputStream byteOutputStream = new ByteOutputStream();
            try {
                XMLHTTPBindingCodec xMLHTTPBindingCodec = new XMLHTTPBindingCodec();
                ContentType contentType = xMLHTTPBindingCodec.getStaticContentType(new Packet(message));
                xMLHTTPBindingCodec.encode(new Packet(message), (OutputStream)byteOutputStream);
                return XMLMessage.createDataSource(contentType.getContentType(), byteOutputStream.newInputStream());
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
        }
        ByteOutputStream byteOutputStream = new ByteOutputStream();
        XMLStreamWriter xMLStreamWriter = XMLStreamWriterFactory.create(byteOutputStream);
        try {
            message.writePayloadTo(xMLStreamWriter);
            xMLStreamWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        return XMLMessage.createDataSource("text/xml", byteOutputStream.newInputStream());
    }

    public static DataSource createDataSource(final String string, final InputStream inputStream) {
        return new DataSource(){

            public InputStream getInputStream() {
                return inputStream;
            }

            public OutputStream getOutputStream() {
                return null;
            }

            public String getContentType() {
                return string;
            }

            public String getName() {
                return "";
            }
        };
    }

    static {
        new AttachmentPartImpl();
    }

    private static class FaultMessage
    extends EmptyMessageImpl {
        public FaultMessage(SOAPVersion sOAPVersion) {
            super(sOAPVersion);
        }

        public boolean isFault() {
            return true;
        }
    }

    public static interface MessageDataSource {
        public boolean hasUnconsumedDataSource();

        public DataSource getDataSource();
    }

    public static class UnknownContent
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource ds;
        private final HeaderList headerList;

        public UnknownContent(String string, InputStream inputStream) {
            this(XMLMessage.createDataSource(string, inputStream));
        }

        public UnknownContent(DataSource dataSource) {
            super(SOAPVersion.SOAP_11);
            this.ds = dataSource;
            this.headerList = new HeaderList();
        }

        private UnknownContent(UnknownContent unknownContent) {
            super(unknownContent.soapVersion);
            this.ds = unknownContent.ds;
            this.headerList = HeaderList.copy(unknownContent.headerList);
        }

        public boolean hasUnconsumedDataSource() {
            return true;
        }

        public DataSource getDataSource() {
            assert (this.ds != null);
            return this.ds;
        }

        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
            throw new UnsupportedOperationException();
        }

        public boolean hasHeaders() {
            return false;
        }

        public boolean isFault() {
            return false;
        }

        public HeaderList getHeaders() {
            return this.headerList;
        }

        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPayload() {
            return false;
        }

        public Source readPayloadAsSource() {
            return null;
        }

        public XMLStreamReader readPayload() throws XMLStreamException {
            throw new WebServiceException("There isn't XML payload. Shouldn't come here.");
        }

        public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        }

        public Message copy() {
            return new UnknownContent(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class XMLAttachmentSet
    implements AttachmentSet {
        private final Map<String, Attachment> attMap = new HashMap<String, Attachment>();

        public XMLAttachmentSet(MimeMultipartParser mimeMultipartParser) {
            this.attMap.putAll(mimeMultipartParser.getAttachmentParts());
        }

        @Override
        public Attachment get(String string) {
            return this.attMap.get(string);
        }

        @Override
        public boolean isEmpty() {
            return this.attMap.isEmpty();
        }

        @Override
        public Iterator<Attachment> iterator() {
            return this.attMap.values().iterator();
        }

        @Override
        public void add(Attachment attachment) {
            this.attMap.put(attachment.getContentId(), attachment);
        }
    }

    public static final class XMLMultiPart
    extends AbstractMessageImpl
    implements MessageDataSource {
        private final DataSource dataSource;
        private MimeMultipartParser mpp;

        public XMLMultiPart(String string, InputStream inputStream) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = XMLMessage.createDataSource(string, inputStream);
        }

        public XMLMultiPart(DataSource dataSource) {
            super(SOAPVersion.SOAP_11);
            this.dataSource = dataSource;
        }

        public DataSource getDataSource() {
            assert (this.dataSource != null);
            return this.dataSource;
        }

        private void convertDataSourceToMessage() {
            if (this.mpp == null) {
                try {
                    this.mpp = new MimeMultipartParser(this.dataSource.getInputStream(), this.dataSource.getContentType());
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
            }
        }

        public boolean isOneWay(@NotNull WSDLPort wSDLPort) {
            return false;
        }

        public boolean isFault() {
            return false;
        }

        public boolean hasHeaders() {
            return false;
        }

        public HeaderList getHeaders() {
            return new HeaderList();
        }

        public AttachmentSet getAttachments() {
            this.convertDataSourceToMessage();
            return new XMLAttachmentSet(this.mpp);
        }

        public String getPayloadLocalPart() {
            throw new UnsupportedOperationException();
        }

        public String getPayloadNamespaceURI() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPayload() {
            return true;
        }

        public Source readPayloadAsSource() {
            this.convertDataSourceToMessage();
            return this.mpp.getRootPart().asSource();
        }

        public XMLStreamReader readPayload() throws XMLStreamException {
            this.convertDataSourceToMessage();
            return XMLStreamReaderFactory.create(null, this.mpp.getRootPart().asInputStream(), true);
        }

        public void writePayloadTo(XMLStreamWriter xMLStreamWriter) {
            XMLStreamReaderToXMLStreamWriter xMLStreamReaderToXMLStreamWriter = new XMLStreamReaderToXMLStreamWriter();
            try {
                XMLStreamReader xMLStreamReader = this.readPayload();
                xMLStreamReaderToXMLStreamWriter.bridge(xMLStreamReader, xMLStreamWriter);
                XMLStreamReaderFactory.recycle(xMLStreamReader);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) {
            throw new UnsupportedOperationException();
        }

        public Message copy() {
            throw new UnsupportedOperationException();
        }

        public boolean hasUnconsumedDataSource() {
            return this.mpp == null;
        }
    }
}

