/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Toolkit;
import java.awt.VKCollection;
import java.awt.event.KeyEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWTKeyStroke
implements Serializable {
    static final long serialVersionUID = -6430539691155161871L;
    private static Map cache;
    private static AWTKeyStroke cacheKey;
    private static Constructor ctor;
    private static Map modifierKeywords;
    private static VKCollection vks;
    private char keyChar = (char)65535;
    private int keyCode = 0;
    private int modifiers;
    private boolean onKeyRelease;

    protected AWTKeyStroke() {
    }

    protected AWTKeyStroke(char c, int n, int n2, boolean bl) {
        this.keyChar = c;
        this.keyCode = n;
        this.modifiers = n2;
        this.onKeyRelease = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerSubclass(Class<?> clazz) {
        Object object;
        if (clazz == null) {
            throw new IllegalArgumentException("subclass cannot be null");
        }
        if (ctor.getDeclaringClass().equals(clazz)) {
            return;
        }
        if (!AWTKeyStroke.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("subclass is not derived from AWTKeyStroke");
        }
        Constructor constructor = AWTKeyStroke.getCtor(clazz);
        String string = "subclass could not be instantiated";
        if (constructor == null) {
            throw new IllegalArgumentException(string);
        }
        try {
            object = (AWTKeyStroke)constructor.newInstance(null);
            if (object == null) {
                throw new IllegalArgumentException(string);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new IllegalArgumentException(string);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new IllegalArgumentException(string);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(string);
        }
        object = AWTKeyStroke.class;
        synchronized (AWTKeyStroke.class) {
            ctor = constructor;
            cache = null;
            cacheKey = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static Constructor getCtor(final Class clazz) {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Constructor constructor = clazz.getDeclaredConstructor(null);
                    if (constructor != null) {
                        constructor.setAccessible(true);
                    }
                    return constructor;
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return null;
            }
        });
        return (Constructor)t;
    }

    private static synchronized AWTKeyStroke getCachedStroke(char c, int n, int n2, boolean bl) {
        block9: {
            if (cache == null) {
                cache = new HashMap();
            }
            if (cacheKey == null) {
                try {
                    cacheKey = (AWTKeyStroke)ctor.newInstance(null);
                }
                catch (InstantiationException instantiationException) {
                    assert (false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    assert (false);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
        }
        AWTKeyStroke.cacheKey.keyChar = c;
        AWTKeyStroke.cacheKey.keyCode = n;
        AWTKeyStroke.cacheKey.modifiers = AWTKeyStroke.mapNewModifiers(AWTKeyStroke.mapOldModifiers(n2));
        AWTKeyStroke.cacheKey.onKeyRelease = bl;
        AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)cache.get(cacheKey);
        if (aWTKeyStroke == null) {
            aWTKeyStroke = cacheKey;
            cache.put(aWTKeyStroke, aWTKeyStroke);
            cacheKey = null;
        }
        return aWTKeyStroke;
    }

    public static AWTKeyStroke getAWTKeyStroke(char c) {
        return AWTKeyStroke.getCachedStroke(c, 0, 0, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(Character c, int n) {
        if (c == null) {
            throw new IllegalArgumentException("keyChar cannot be null");
        }
        return AWTKeyStroke.getCachedStroke(c.charValue(), 0, n, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(int n, int n2, boolean bl) {
        return AWTKeyStroke.getCachedStroke('\uffff', n, n2, bl);
    }

    public static AWTKeyStroke getAWTKeyStroke(int n, int n2) {
        return AWTKeyStroke.getCachedStroke('\uffff', n, n2, false);
    }

    public static AWTKeyStroke getAWTKeyStrokeForEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        switch (n) {
            case 401: 
            case 402: {
                return AWTKeyStroke.getCachedStroke('\uffff', keyEvent.getKeyCode(), keyEvent.getModifiers(), n == 402);
            }
            case 400: {
                return AWTKeyStroke.getCachedStroke(keyEvent.getKeyChar(), 0, keyEvent.getModifiers(), false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static AWTKeyStroke getAWTKeyStroke(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (modifierKeywords == null) {
            Class<AWTKeyStroke> clazz = AWTKeyStroke.class;
            // MONITORENTER : java.awt.AWTKeyStroke.class
            if (modifierKeywords == null) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>(8, 1.0f);
                hashMap.put("shift", 65);
                hashMap.put("control", 130);
                hashMap.put("ctrl", 130);
                hashMap.put("meta", 260);
                hashMap.put("alt", 520);
                hashMap.put("altGraph", 8224);
                hashMap.put("button1", 1024);
                hashMap.put("button2", 2048);
                hashMap.put("button3", 4096);
                modifierKeywords = Collections.synchronizedMap(hashMap);
            }
            // MONITOREXIT : clazz
        }
        int n2 = stringTokenizer.countTokens();
        int n3 = 1;
        while (n3 <= n2) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (bl2) {
                if (string2.length() != 1) throw new IllegalArgumentException("String formatted incorrectly");
                if (n3 == n2) return AWTKeyStroke.getCachedStroke(string2.charAt(0), 0, n, false);
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            if (bl3 || bl || n3 == n2) {
                if (n3 != n2) {
                    throw new IllegalArgumentException("String formatted incorrectly");
                }
                object = "VK_" + string2;
                int n4 = AWTKeyStroke.getVKValue((String)object);
                return AWTKeyStroke.getCachedStroke('\uffff', n4, n, bl);
            }
            if (string2.equals("released")) {
                bl = true;
            } else if (string2.equals("pressed")) {
                bl3 = true;
            } else if (string2.equals("typed")) {
                bl2 = true;
            } else {
                object = (Integer)modifierKeywords.get(string2);
                if (object == null) throw new IllegalArgumentException("String formatted incorrectly");
                n |= ((Integer)object).intValue();
            }
            ++n3;
        }
        throw new IllegalArgumentException("String formatted incorrectly");
    }

    private static VKCollection getVKCollection() {
        if (vks == null) {
            vks = new VKCollection();
        }
        return vks;
    }

    private static int getVKValue(String string) {
        VKCollection vKCollection = AWTKeyStroke.getVKCollection();
        Integer n = vKCollection.findCode(string);
        if (n == null) {
            int n2 = 0;
            try {
                n2 = KeyEvent.class.getField(string).getInt(KeyEvent.class);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("String formatted incorrectly");
            }
            n = n2;
            vKCollection.put(string, n);
        }
        return n;
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final boolean isOnKeyRelease() {
        return this.onKeyRelease;
    }

    public final int getKeyEventType() {
        if (this.keyCode == 0) {
            return 400;
        }
        return this.onKeyRelease ? 402 : 401;
    }

    public int hashCode() {
        return (this.keyChar + '\u0001') * (2 * (this.keyCode + 1)) * (this.modifiers + 1) + (this.onKeyRelease ? 1 : 2);
    }

    public final boolean equals(Object object) {
        if (object instanceof AWTKeyStroke) {
            AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)object;
            return aWTKeyStroke.keyChar == this.keyChar && aWTKeyStroke.keyCode == this.keyCode && aWTKeyStroke.onKeyRelease == this.onKeyRelease && aWTKeyStroke.modifiers == this.modifiers;
        }
        return false;
    }

    public String toString() {
        if (this.keyCode == 0) {
            return AWTKeyStroke.getModifiersText(this.modifiers) + "typed " + this.keyChar;
        }
        return AWTKeyStroke.getModifiersText(this.modifiers) + (this.onKeyRelease ? "released" : "pressed") + " " + AWTKeyStroke.getVKText(this.keyCode);
    }

    static String getModifiersText(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 0x40) != 0) {
            stringBuffer.append("shift ");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append("ctrl ");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("meta ");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append("alt ");
        }
        if ((n & 0x2000) != 0) {
            stringBuffer.append("altGraph ");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append("button1 ");
        }
        if ((n & 0x800) != 0) {
            stringBuffer.append("button2 ");
        }
        if ((n & 0x1000) != 0) {
            stringBuffer.append("button3 ");
        }
        return stringBuffer.toString();
    }

    static String getVKText(int n) {
        Integer n2;
        VKCollection vKCollection = AWTKeyStroke.getVKCollection();
        String string = vKCollection.findName(n2 = Integer.valueOf(n));
        if (string != null) {
            return string.substring(3);
        }
        int n3 = 25;
        Field[] fieldArray = KeyEvent.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            try {
                if (fieldArray[i].getModifiers() != n3 || fieldArray[i].getType() != Integer.TYPE || !fieldArray[i].getName().startsWith("VK_") || fieldArray[i].getInt(KeyEvent.class) != n) continue;
                string = fieldArray[i].getName();
                vKCollection.put(string, n2);
                return string.substring(3);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
                continue;
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() throws ObjectStreamException {
        Class<AWTKeyStroke> clazz = AWTKeyStroke.class;
        synchronized (AWTKeyStroke.class) {
            Class<?> clazz2 = this.getClass();
            if (!clazz2.equals(ctor.getDeclaringClass())) {
                AWTKeyStroke.registerSubclass(clazz2);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return AWTKeyStroke.getCachedStroke(this.keyChar, this.keyCode, this.modifiers, this.onKeyRelease);
        }
    }

    private static int mapOldModifiers(int n) {
        if ((n & 1) != 0) {
            n |= 0x40;
        }
        if ((n & 8) != 0) {
            n |= 0x200;
        }
        if ((n & 0x20) != 0) {
            n |= 0x2000;
        }
        if ((n & 2) != 0) {
            n |= 0x80;
        }
        if ((n & 4) != 0) {
            n |= 0x100;
        }
        return n &= 0x3FC0;
    }

    private static int mapNewModifiers(int n) {
        if ((n & 0x40) != 0) {
            n |= 1;
        }
        if ((n & 0x200) != 0) {
            n |= 8;
        }
        if ((n & 0x2000) != 0) {
            n |= 0x20;
        }
        if ((n & 0x80) != 0) {
            n |= 2;
        }
        if ((n & 0x100) != 0) {
            n |= 4;
        }
        return n;
    }

    static {
        ctor = AWTKeyStroke.getCtor(AWTKeyStroke.class);
        Toolkit.loadLibraries();
    }
}

