/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;

    public ShortMessage() {
        this(new byte[3]);
        this.data[0] = -112;
        this.data[1] = 64;
        this.data[2] = 127;
        this.length = 3;
    }

    protected ShortMessage(byte[] byArray) {
        super(byArray);
    }

    public void setMessage(int n) throws InvalidMidiDataException {
        int n2 = this.getDataLength(n);
        if (n2 != 0) {
            throw new InvalidMidiDataException("Status byte; " + n + " requires " + n2 + " data bytes");
        }
        this.setMessage(n, 0, 0);
    }

    public void setMessage(int n, int n2, int n3) throws InvalidMidiDataException {
        int n4 = this.getDataLength(n);
        if (n4 > 0) {
            if (n2 < 0 || n2 > 127) {
                throw new InvalidMidiDataException("data1 out of range: " + n2);
            }
            if (n4 > 1 && (n3 < 0 || n3 > 127)) {
                throw new InvalidMidiDataException("data2 out of range: " + n3);
            }
        }
        this.length = n4 + 1;
        if (this.data == null || this.data.length < this.length) {
            this.data = new byte[3];
        }
        this.data[0] = (byte)(n & 0xFF);
        if (this.length > 1) {
            this.data[1] = (byte)(n2 & 0xFF);
            if (this.length > 2) {
                this.data[2] = (byte)(n3 & 0xFF);
            }
        }
    }

    public void setMessage(int n, int n2, int n3, int n4) throws InvalidMidiDataException {
        if (n >= 240 || n < 128) {
            throw new InvalidMidiDataException("command out of range: 0x" + Integer.toHexString(n));
        }
        if ((n2 & 0xFFFFFFF0) != 0) {
            throw new InvalidMidiDataException("channel out of range: " + n2);
        }
        this.setMessage(n & 0xF0 | n2 & 0xF, n3, n4);
    }

    public int getChannel() {
        return this.getStatus() & 0xF;
    }

    public int getCommand() {
        return this.getStatus() & 0xF0;
    }

    public int getData1() {
        if (this.length > 1) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    public int getData2() {
        if (this.length > 2) {
            return this.data[2] & 0xFF;
        }
        return 0;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, byArray.length);
        ShortMessage shortMessage = new ShortMessage(byArray);
        return shortMessage;
    }

    protected final int getDataLength(int n) throws InvalidMidiDataException {
        switch (n) {
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return 0;
            }
            case 241: 
            case 243: {
                return 1;
            }
            case 242: {
                return 2;
            }
        }
        switch (n & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + n);
    }
}

