/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class OAEPParameters
extends AlgorithmParametersSpi {
    private String a;
    private MGF1ParameterSpec b;
    private byte[] c;
    private static ObjectIdentifier d;
    private static ObjectIdentifier e;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
        this.a = oAEPParameterSpec.getDigestAlgorithm();
        String string = oAEPParameterSpec.getMGFAlgorithm();
        if (!string.equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + string + "; MGF1 only");
        }
        AlgorithmParameterSpec algorithmParameterSpec2 = oAEPParameterSpec.getMGFParameters();
        if (!(algorithmParameterSpec2 instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.b = (MGF1ParameterSpec)algorithmParameterSpec2;
        PSource pSource = oAEPParameterSpec.getPSource();
        if (!pSource.getAlgorithm().equals("PSpecified")) {
            throw new InvalidParameterSpecException("Unsupported pSource " + pSource.getAlgorithm() + "; PSpecified only");
        }
        this.c = ((PSource.PSpecified)pSource).getValue();
    }

    private static String a(String string) {
        if (string.equals("SHA")) {
            return "SHA-1";
        }
        if (string.equals("SHA256")) {
            return "SHA-256";
        }
        if (string.equals("SHA384")) {
            return "SHA-384";
        }
        if (string.equals("SHA512")) {
            return "SHA-512";
        }
        return string;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.a = "SHA-1";
        this.b = MGF1ParameterSpec.SHA1;
        this.c = new byte[0];
        DerValue[] derValueArray = derInputStream.getSequence(3);
        for (int i = 0; i < derValueArray.length; ++i) {
            Object object;
            AlgorithmId algorithmId;
            DerValue derValue = derValueArray[i];
            if (derValue.isContextSpecific((byte)0)) {
                this.a = OAEPParameters.a(AlgorithmId.parse(derValue.data.getDerValue()).getName());
                continue;
            }
            if (derValue.isContextSpecific((byte)1)) {
                algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
                if (!algorithmId.getOID().equals(d)) {
                    throw new IOException("Only MGF1 mgf is supported");
                }
                object = AlgorithmId.parse(new DerValue(algorithmId.getEncodedParams()));
                String string = OAEPParameters.a(((AlgorithmId)object).getName());
                if (string.equals("SHA-1")) {
                    this.b = MGF1ParameterSpec.SHA1;
                    continue;
                }
                if (string.equals("SHA-256")) {
                    this.b = MGF1ParameterSpec.SHA256;
                    continue;
                }
                if (string.equals("SHA-384")) {
                    this.b = MGF1ParameterSpec.SHA384;
                    continue;
                }
                if (string.equals("SHA-512")) {
                    this.b = MGF1ParameterSpec.SHA512;
                    continue;
                }
                throw new IOException("Unrecognized message digest algorithm");
            }
            if (derValue.isContextSpecific((byte)2)) {
                algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
                if (!algorithmId.getOID().equals(e)) {
                    throw new IOException("Wrong OID for pSpecified");
                }
                object = new DerInputStream(algorithmId.getEncodedParams());
                this.c = ((DerInputStream)object).getOctetString();
                if (((DerInputStream)object).available() == 0) continue;
                throw new IOException("Extra data for pSpecified");
            }
            throw new IOException("Invalid encoded OAEPParameters");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (OAEPParameterSpec.class.isAssignableFrom(clazz)) {
            return new OAEPParameterSpec(this.a, "MGF1", this.b, new PSource.PSpecified(this.c));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    protected byte[] engineGetEncoded() throws IOException {
        AlgorithmId algorithmId;
        AlgorithmId algorithmId2;
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            algorithmId2 = AlgorithmId.get(this.a);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + this.a + " impl not found");
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        algorithmId2.derEncode(derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(d);
        try {
            algorithmId = AlgorithmId.get(this.b.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + this.b.getDigestAlgorithm() + " impl not found");
        }
        algorithmId.encode(derOutputStream2);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream3);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(e);
        derOutputStream2.putOctetString(this.c);
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream3);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream);
        return derOutputStream4.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string != null && !string.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MD: " + this.a + "\n");
        stringBuffer.append("MGF: MGF1" + this.b.getDigestAlgorithm() + "\n");
        stringBuffer.append("PSource: PSpecified " + (this.c.length == 0 ? "" : Debug.toHexString(new BigInteger(this.c))) + "\n");
        return stringBuffer.toString();
    }

    static {
        try {
            d = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 8});
        }
        catch (IOException iOException) {
            d = null;
        }
        try {
            e = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 9});
        }
        catch (IOException iOException) {
            e = null;
        }
    }
}

