/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.message.ExceptionHasMessage;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.server.AbstractServerAsyncTransport;
import com.sun.xml.internal.ws.api.server.Adapter;
import com.sun.xml.internal.ws.api.server.DocumentAddressResolver;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.SDDocument;
import com.sun.xml.internal.ws.api.server.ServiceDefinition;
import com.sun.xml.internal.ws.api.server.TransportBackChannel;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import com.sun.xml.internal.ws.transport.http.HttpAdapterList;
import com.sun.xml.internal.ws.transport.http.WSHTTPConnection;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAdapter
extends Adapter<HttpToolkit> {
    public final Map<String, SDDocument> wsdls;
    public final Map<SDDocument, String> revWsdls;
    public final HttpAdapterList<? extends HttpAdapter> owner;
    public static boolean dump;
    private static final Logger LOGGER;

    public static HttpAdapter createAlone(WSEndpoint wSEndpoint) {
        return new DummyList().createAdapter("", "", wSEndpoint);
    }

    protected HttpAdapter(WSEndpoint wSEndpoint, HttpAdapterList<? extends HttpAdapter> httpAdapterList) {
        super(wSEndpoint);
        this.owner = httpAdapterList;
        ServiceDefinition serviceDefinition = this.endpoint.getServiceDefinition();
        if (serviceDefinition == null) {
            this.wsdls = Collections.emptyMap();
            this.revWsdls = Collections.emptyMap();
        } else {
            this.wsdls = new HashMap<String, SDDocument>();
            TreeMap<String, SDDocument> treeMap = new TreeMap<String, SDDocument>();
            for (SDDocument sDDocument : serviceDefinition) {
                if (sDDocument == serviceDefinition.getPrimary()) {
                    this.wsdls.put("wsdl", sDDocument);
                    this.wsdls.put("WSDL", sDDocument);
                    continue;
                }
                treeMap.put(sDDocument.getURL().toString(), sDDocument);
            }
            int n = 1;
            int n2 = 1;
            for (Map.Entry entry : treeMap.entrySet()) {
                SDDocument sDDocument = (SDDocument)entry.getValue();
                if (sDDocument.isWSDL()) {
                    this.wsdls.put("wsdl=" + n++, sDDocument);
                }
                if (!sDDocument.isSchema()) continue;
                this.wsdls.put("xsd=" + n2++, sDDocument);
            }
            this.revWsdls = new HashMap<SDDocument, String>();
            for (Map.Entry<Object, Object> entry : this.wsdls.entrySet()) {
                if (((String)entry.getKey()).equals("WSDL")) continue;
                this.revWsdls.put((SDDocument)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    @Override
    protected HttpToolkit createToolkit() {
        return new HttpToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull WSHTTPConnection wSHTTPConnection) throws IOException {
        HttpToolkit httpToolkit = (HttpToolkit)this.pool.take();
        try {
            httpToolkit.handle(wSHTTPConnection);
        }
        finally {
            this.pool.recycle(httpToolkit);
        }
    }

    private Packet decodePacket(@NotNull WSHTTPConnection wSHTTPConnection, @NotNull Codec codec) throws IOException {
        String string = wSHTTPConnection.getRequestHeader("Content-Type");
        InputStream inputStream = wSHTTPConnection.getInput();
        Packet packet = new Packet();
        packet.soapAction = wSHTTPConnection.getRequestHeader("SOAPAction");
        packet.wasTransportSecure = wSHTTPConnection.isSecure();
        packet.acceptableMimeTypes = wSHTTPConnection.getRequestHeader("Accept");
        packet.addSatellite(wSHTTPConnection);
        packet.transportBackChannel = new Oneway(wSHTTPConnection);
        packet.webServiceContextDelegate = wSHTTPConnection.getWebServiceContextDelegate();
        if (dump) {
            ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.write(inputStream);
            this.dump(byteArrayBuffer, "HTTP request", wSHTTPConnection.getRequestHeaders());
            inputStream = byteArrayBuffer.newInputStream();
        }
        codec.decode(inputStream, string, packet);
        return packet;
    }

    private void encodePacket(@NotNull Packet packet, @NotNull WSHTTPConnection wSHTTPConnection, @NotNull Codec codec) throws IOException {
        if (wSHTTPConnection.isClosed()) {
            return;
        }
        Message message = packet.getMessage();
        if (message == null) {
            if (!wSHTTPConnection.isClosed()) {
                if (wSHTTPConnection.getStatus() == 0) {
                    wSHTTPConnection.setStatus(202);
                }
                try {
                    wSHTTPConnection.getOutput().close();
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
            }
        } else {
            ContentType contentType;
            if (wSHTTPConnection.getStatus() == 0) {
                wSHTTPConnection.setStatus(message.isFault() ? 500 : 200);
            }
            if ((contentType = codec.getStaticContentType(packet)) != null) {
                OutputStream outputStream;
                wSHTTPConnection.setContentTypeResponseHeader(contentType.getContentType());
                OutputStream outputStream2 = outputStream = wSHTTPConnection.getProtocol().contains("1.1") ? wSHTTPConnection.getOutput() : new Http10OutputStream(wSHTTPConnection);
                if (dump) {
                    ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                    codec.encode(packet, byteArrayBuffer);
                    this.dump(byteArrayBuffer, "HTTP response " + wSHTTPConnection.getStatus(), wSHTTPConnection.getResponseHeaders());
                    byteArrayBuffer.writeTo(outputStream);
                } else {
                    codec.encode(packet, outputStream);
                }
                outputStream.close();
            } else {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                contentType = codec.encode(packet, byteArrayBuffer);
                wSHTTPConnection.setContentTypeResponseHeader(contentType.getContentType());
                if (dump) {
                    this.dump(byteArrayBuffer, "HTTP response " + wSHTTPConnection.getStatus(), wSHTTPConnection.getResponseHeaders());
                }
                OutputStream outputStream = wSHTTPConnection.getOutput();
                byteArrayBuffer.writeTo(outputStream);
                outputStream.close();
            }
        }
    }

    public void invokeAsync(final WSHTTPConnection wSHTTPConnection) throws IOException {
        Packet packet;
        final HttpToolkit httpToolkit = (HttpToolkit)this.pool.take();
        try {
            packet = this.decodePacket(wSHTTPConnection, httpToolkit.codec);
        }
        catch (ExceptionHasMessage exceptionHasMessage) {
            LOGGER.log(Level.SEVERE, exceptionHasMessage.getMessage(), exceptionHasMessage);
            Packet packet2 = new Packet();
            packet2.setMessage(exceptionHasMessage.getFaultMessage());
            this.encodePacket(packet2, wSHTTPConnection, httpToolkit.codec);
            this.pool.recycle(httpToolkit);
            wSHTTPConnection.close();
            return;
        }
        catch (UnsupportedMediaException unsupportedMediaException) {
            LOGGER.log(Level.SEVERE, unsupportedMediaException.getMessage(), unsupportedMediaException);
            Packet packet3 = new Packet();
            wSHTTPConnection.setStatus(415);
            this.encodePacket(packet3, wSHTTPConnection, httpToolkit.codec);
            this.pool.recycle(httpToolkit);
            wSHTTPConnection.close();
            return;
        }
        this.endpoint.schedule(packet, new WSEndpoint.CompletionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(@NotNull Packet packet) {
                try {
                    try {
                        HttpAdapter.this.encodePacket(packet, wSHTTPConnection, httpToolkit.codec);
                    }
                    catch (IOException iOException) {
                        LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                    }
                    HttpAdapter.this.pool.recycle(httpToolkit);
                }
                finally {
                    wSHTTPConnection.close();
                }
            }
        });
    }

    public final boolean isMetadataQuery(String string) {
        return string != null && (string.equals("WSDL") || string.startsWith("wsdl") || string.startsWith("xsd="));
    }

    public void publishWSDL(WSHTTPConnection wSHTTPConnection, String string, String string2) throws IOException {
        InputStream inputStream = wSHTTPConnection.getInput();
        while (inputStream.read() != -1) {
        }
        inputStream.close();
        SDDocument sDDocument = this.wsdls.get(string2);
        if (sDDocument == null) {
            this.writeNotFoundErrorPage(wSHTTPConnection, "Invalid Request");
            return;
        }
        wSHTTPConnection.setStatus(200);
        wSHTTPConnection.setContentTypeResponseHeader("text/xml;charset=utf-8");
        OutputStream outputStream = wSHTTPConnection.getProtocol().contains("1.1") ? wSHTTPConnection.getOutput() : new Http10OutputStream(wSHTTPConnection);
        PortAddressResolver portAddressResolver = this.owner.createPortAddressResolver(string);
        final String string3 = portAddressResolver.getAddressFor(this.endpoint.getServiceName(), this.endpoint.getPortName().getLocalPart());
        assert (string3 != null);
        DocumentAddressResolver documentAddressResolver = new DocumentAddressResolver(){

            public String getRelativeAddressFor(@NotNull SDDocument sDDocument, @NotNull SDDocument sDDocument2) {
                assert (HttpAdapter.this.revWsdls.containsKey(sDDocument2));
                return string3 + '?' + HttpAdapter.this.revWsdls.get(sDDocument2);
            }
        };
        sDDocument.writeTo(portAddressResolver, documentAddressResolver, outputStream);
        outputStream.close();
    }

    private void writeNotFoundErrorPage(WSHTTPConnection wSHTTPConnection, String string) throws IOException {
        wSHTTPConnection.setStatus(404);
        wSHTTPConnection.setContentTypeResponseHeader("text/html; charset=UTF-8");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(wSHTTPConnection.getOutput(), "UTF-8"));
        printWriter.println("<html>");
        printWriter.println("<head><title>");
        printWriter.println(WsservletMessages.SERVLET_HTML_TITLE());
        printWriter.println("</title></head>");
        printWriter.println("<body>");
        printWriter.println(WsservletMessages.SERVLET_HTML_NOT_FOUND(string));
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
    }

    private void writeInternalServerError(WSHTTPConnection wSHTTPConnection) throws IOException {
        wSHTTPConnection.setStatus(500);
        wSHTTPConnection.getOutput().close();
    }

    private void dump(ByteArrayBuffer byteArrayBuffer, String string, Map<String, List<String>> map) throws IOException {
        System.out.println("---[" + string + "]---");
        if (map != null) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                if (entry.getValue().isEmpty()) {
                    System.out.println(entry.getValue());
                    continue;
                }
                for (String string2 : entry.getValue()) {
                    System.out.println(entry.getKey() + ": " + string2);
                }
            }
        }
        byteArrayBuffer.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean bl;
        try {
            bl = Boolean.getBoolean(HttpAdapter.class.getName() + ".dump");
        }
        catch (Throwable throwable) {
            bl = false;
        }
        dump = bl;
        LOGGER = Logger.getLogger(HttpAdapter.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsyncTransport
    extends AbstractServerAsyncTransport<WSHTTPConnection> {
        public AsyncTransport() {
            super(HttpAdapter.this.endpoint);
        }

        public void handleAsync(WSHTTPConnection wSHTTPConnection) throws IOException {
            super.handle(wSHTTPConnection);
        }

        @Override
        protected void encodePacket(WSHTTPConnection wSHTTPConnection, @NotNull Packet packet, @NotNull Codec codec) throws IOException {
            HttpAdapter.this.encodePacket(packet, wSHTTPConnection, codec);
        }

        @Override
        @Nullable
        protected String getAcceptableMimeTypes(WSHTTPConnection wSHTTPConnection) {
            return null;
        }

        @Override
        @Nullable
        protected TransportBackChannel getTransportBackChannel(WSHTTPConnection wSHTTPConnection) {
            return new Oneway(wSHTTPConnection);
        }

        @Override
        @NotNull
        protected PropertySet getPropertySet(WSHTTPConnection wSHTTPConnection) {
            return wSHTTPConnection;
        }

        @Override
        @NotNull
        protected WebServiceContextDelegate getWebServiceContextDelegate(WSHTTPConnection wSHTTPConnection) {
            return wSHTTPConnection.getWebServiceContextDelegate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyList
    extends HttpAdapterList<HttpAdapter> {
        private DummyList() {
        }

        @Override
        protected HttpAdapter createHttpAdapter(String string, String string2, WSEndpoint<?> wSEndpoint) {
            return new HttpAdapter(wSEndpoint, this);
        }
    }

    private static final class Http10OutputStream
    extends ByteArrayBuffer {
        private final WSHTTPConnection con;

        Http10OutputStream(WSHTTPConnection wSHTTPConnection) {
            this.con = wSHTTPConnection;
        }

        public void close() throws IOException {
            super.close();
            this.con.setContentLengthResponseHeader(this.size());
            OutputStream outputStream = this.con.getOutput();
            this.writeTo(outputStream);
            outputStream.close();
        }
    }

    final class HttpToolkit
    extends Adapter.Toolkit {
        HttpToolkit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WSHTTPConnection wSHTTPConnection) throws IOException {
            try {
                Packet packet = new Packet();
                try {
                    packet = HttpAdapter.this.decodePacket(wSHTTPConnection, this.codec);
                }
                catch (ExceptionHasMessage exceptionHasMessage) {
                    LOGGER.log(Level.SEVERE, exceptionHasMessage.getMessage(), exceptionHasMessage);
                    packet.setMessage(exceptionHasMessage.getFaultMessage());
                }
                catch (UnsupportedMediaException unsupportedMediaException) {
                    LOGGER.log(Level.SEVERE, unsupportedMediaException.getMessage(), unsupportedMediaException);
                    wSHTTPConnection.setStatus(415);
                }
                catch (ServerRtException serverRtException) {
                    LOGGER.log(Level.SEVERE, serverRtException.getMessage(), serverRtException);
                }
                if (packet.getMessage() != null && !packet.getMessage().isFault()) {
                    try {
                        packet = this.head.process(packet, wSHTTPConnection.getWebServiceContextDelegate(), packet.transportBackChannel);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.SEVERE, exception.getMessage(), exception);
                        if (!wSHTTPConnection.isClosed()) {
                            HttpAdapter.this.writeInternalServerError(wSHTTPConnection);
                        }
                        if (!wSHTTPConnection.isClosed()) {
                            wSHTTPConnection.close();
                        }
                        return;
                    }
                }
                HttpAdapter.this.encodePacket(packet, wSHTTPConnection, this.codec);
            }
            finally {
                if (!wSHTTPConnection.isClosed()) {
                    wSHTTPConnection.close();
                }
            }
        }
    }

    final class Oneway
    implements TransportBackChannel {
        WSHTTPConnection con;

        Oneway(WSHTTPConnection wSHTTPConnection) {
            this.con = wSHTTPConnection;
        }

        public void close() {
            if (!this.con.isClosed()) {
                this.con.setStatus(202);
                try {
                    this.con.getOutput().close();
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                this.con.close();
            }
        }
    }
}

