/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.DefaultSynthStyleFactory;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthCheckBoxMenuItemUI;
import javax.swing.plaf.synth.SynthCheckBoxUI;
import javax.swing.plaf.synth.SynthColorChooserUI;
import javax.swing.plaf.synth.SynthComboBoxUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthDefaultLookup;
import javax.swing.plaf.synth.SynthDesktopIconUI;
import javax.swing.plaf.synth.SynthDesktopPaneUI;
import javax.swing.plaf.synth.SynthEditorPaneUI;
import javax.swing.plaf.synth.SynthFormattedTextFieldUI;
import javax.swing.plaf.synth.SynthInternalFrameUI;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthListUI;
import javax.swing.plaf.synth.SynthMenuBarUI;
import javax.swing.plaf.synth.SynthMenuItemUI;
import javax.swing.plaf.synth.SynthMenuUI;
import javax.swing.plaf.synth.SynthOptionPaneUI;
import javax.swing.plaf.synth.SynthPanelUI;
import javax.swing.plaf.synth.SynthParser;
import javax.swing.plaf.synth.SynthPasswordFieldUI;
import javax.swing.plaf.synth.SynthPopupMenuUI;
import javax.swing.plaf.synth.SynthProgressBarUI;
import javax.swing.plaf.synth.SynthRadioButtonMenuItemUI;
import javax.swing.plaf.synth.SynthRadioButtonUI;
import javax.swing.plaf.synth.SynthRootPaneUI;
import javax.swing.plaf.synth.SynthScrollBarUI;
import javax.swing.plaf.synth.SynthScrollPaneUI;
import javax.swing.plaf.synth.SynthSeparatorUI;
import javax.swing.plaf.synth.SynthSliderUI;
import javax.swing.plaf.synth.SynthSpinnerUI;
import javax.swing.plaf.synth.SynthSplitPaneUI;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthStyleFactory;
import javax.swing.plaf.synth.SynthTabbedPaneUI;
import javax.swing.plaf.synth.SynthTableHeaderUI;
import javax.swing.plaf.synth.SynthTableUI;
import javax.swing.plaf.synth.SynthTextAreaUI;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.plaf.synth.SynthTextPaneUI;
import javax.swing.plaf.synth.SynthToggleButtonUI;
import javax.swing.plaf.synth.SynthToolBarUI;
import javax.swing.plaf.synth.SynthToolTipUI;
import javax.swing.plaf.synth.SynthTreeUI;
import javax.swing.plaf.synth.SynthViewportUI;
import sun.awt.AppContext;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthFileChooserUI;
import sun.swing.plaf.synth.SynthUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynthLookAndFeel
extends BasicLookAndFeel {
    static final Insets EMPTY_UIRESOURCE_INSETS = new InsetsUIResource(0, 0, 0, 0);
    private static final Object STYLE_FACTORY_KEY = new StringBuffer("com.sun.java.swing.plaf.gtk.StyleCache");
    private static SynthStyleFactory lastFactory;
    private static boolean multipleApps;
    private static AppContext lastContext;
    static ComponentUI selectedUI;
    static int selectedUIState;
    private SynthStyleFactory factory = new DefaultSynthStyleFactory();
    private Map defaultsMap;
    private Handler _handler = new Handler();
    private static ReferenceQueue queue;

    static void setSelectedUI(ComponentUI componentUI, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        selectedUI = componentUI;
        selectedUIState = 0;
        if (bl) {
            selectedUIState = 512;
            if (bl2) {
                selectedUIState |= 0x100;
            }
        } else if (bl4 && bl3) {
            selectedUIState |= 3;
            if (bl2) {
                selectedUIState |= 0x100;
            }
        } else if (bl3) {
            selectedUIState |= 1;
            selectedUIState = 256;
        } else {
            selectedUIState |= 8;
        }
    }

    static void resetSelectedUI() {
        selectedUI = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStyleFactory(SynthStyleFactory synthStyleFactory) {
        Class<SynthLookAndFeel> clazz = SynthLookAndFeel.class;
        synchronized (SynthLookAndFeel.class) {
            AppContext appContext = AppContext.getAppContext();
            if (!multipleApps && appContext != lastContext && lastContext != null) {
                multipleApps = true;
            }
            lastFactory = synthStyleFactory;
            lastContext = appContext;
            appContext.put(STYLE_FACTORY_KEY, synthStyleFactory);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynthStyleFactory getStyleFactory() {
        Class<SynthLookAndFeel> clazz = SynthLookAndFeel.class;
        synchronized (SynthLookAndFeel.class) {
            if (!multipleApps) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return lastFactory;
            }
            AppContext appContext = AppContext.getAppContext();
            if (lastContext == appContext) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return lastFactory;
            }
            lastContext = appContext;
            lastFactory = (SynthStyleFactory)AppContext.getAppContext().get(STYLE_FACTORY_KEY);
            // ** MonitorExit[var0] (shouldn't be in output)
            return lastFactory;
        }
    }

    static int getComponentState(Component component) {
        if (component.isEnabled()) {
            if (component.isFocusOwner()) {
                return 257;
            }
            return 1;
        }
        return 8;
    }

    public static SynthStyle getStyle(JComponent jComponent, Region region) {
        return SynthLookAndFeel.getStyleFactory().getStyle(jComponent, region);
    }

    static boolean shouldUpdateStyle(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("name" == string) {
            return true;
        }
        if ("componentOrientation" == string) {
            return true;
        }
        if ("ancestor" == string && propertyChangeEvent.getNewValue() != null) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            return lookAndFeel instanceof SynthLookAndFeel && ((SynthLookAndFeel)lookAndFeel).shouldUpdateStyleOnAncestorChanged();
        }
        if ("Nimbus.Overrides" == string) {
            return true;
        }
        if ("Nimbus.Overrides.InheritDefaults" == string) {
            return true;
        }
        return "JComponent.sizeVariant" == string;
    }

    static SynthStyle updateStyle(SynthContext synthContext, SynthUI synthUI) {
        SynthStyle synthStyle;
        SynthStyle synthStyle2 = SynthLookAndFeel.getStyle(synthContext.getComponent(), synthContext.getRegion());
        if (synthStyle2 != (synthStyle = synthContext.getStyle())) {
            if (synthStyle != null) {
                synthStyle.uninstallDefaults(synthContext);
            }
            synthContext.setStyle(synthStyle2);
            synthStyle2.installDefaults(synthContext, synthUI);
        }
        return synthStyle2;
    }

    public static void updateStyles(Component component) {
        SynthLookAndFeel._updateStyles(component);
        component.repaint();
    }

    private static void _updateStyles(Component component) {
        Component[] componentArray;
        if (component instanceof JComponent) {
            componentArray = component.getName();
            component.setName(null);
            if (componentArray != null) {
                component.setName((String)componentArray);
            }
            ((JComponent)component).revalidate();
        }
        componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                SynthLookAndFeel.updateStyles(componentArray[i]);
            }
        }
    }

    public static Region getRegion(JComponent jComponent) {
        return Region.getRegion(jComponent);
    }

    static Insets getPaintingInsets(SynthContext synthContext, Insets insets) {
        insets = synthContext.isSubregion() ? synthContext.getStyle().getInsets(synthContext, insets) : synthContext.getComponent().getInsets(insets);
        return insets;
    }

    static void update(SynthContext synthContext, Graphics graphics) {
        SynthLookAndFeel.paintRegion(synthContext, graphics, null);
    }

    static void updateSubregion(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.paintRegion(synthContext, graphics, rectangle);
    }

    private static void paintRegion(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        int n4;
        JComponent jComponent = synthContext.getComponent();
        SynthStyle synthStyle = synthContext.getStyle();
        if (rectangle == null) {
            n4 = 0;
            n3 = 0;
            n2 = jComponent.getWidth();
            n = jComponent.getHeight();
        } else {
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
        }
        boolean bl = synthContext.isSubregion();
        if (bl && synthStyle.isOpaque(synthContext) || !bl && jComponent.isOpaque()) {
            graphics.setColor(synthStyle.getColor(synthContext, ColorType.BACKGROUND));
            graphics.fillRect(n4, n3, n2, n);
        }
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        String string = jComponent.getUIClassID().intern();
        if (string == "ButtonUI") {
            return SynthButtonUI.createUI(jComponent);
        }
        if (string == "CheckBoxUI") {
            return SynthCheckBoxUI.createUI(jComponent);
        }
        if (string == "CheckBoxMenuItemUI") {
            return SynthCheckBoxMenuItemUI.createUI(jComponent);
        }
        if (string == "ColorChooserUI") {
            return SynthColorChooserUI.createUI(jComponent);
        }
        if (string == "ComboBoxUI") {
            return SynthComboBoxUI.createUI(jComponent);
        }
        if (string == "DesktopPaneUI") {
            return SynthDesktopPaneUI.createUI(jComponent);
        }
        if (string == "DesktopIconUI") {
            return SynthDesktopIconUI.createUI(jComponent);
        }
        if (string == "EditorPaneUI") {
            return SynthEditorPaneUI.createUI(jComponent);
        }
        if (string == "FileChooserUI") {
            return SynthFileChooserUI.createUI(jComponent);
        }
        if (string == "FormattedTextFieldUI") {
            return SynthFormattedTextFieldUI.createUI(jComponent);
        }
        if (string == "InternalFrameUI") {
            return SynthInternalFrameUI.createUI(jComponent);
        }
        if (string == "LabelUI") {
            return SynthLabelUI.createUI(jComponent);
        }
        if (string == "ListUI") {
            return SynthListUI.createUI(jComponent);
        }
        if (string == "MenuBarUI") {
            return SynthMenuBarUI.createUI(jComponent);
        }
        if (string == "MenuUI") {
            return SynthMenuUI.createUI(jComponent);
        }
        if (string == "MenuItemUI") {
            return SynthMenuItemUI.createUI(jComponent);
        }
        if (string == "OptionPaneUI") {
            return SynthOptionPaneUI.createUI(jComponent);
        }
        if (string == "PanelUI") {
            return SynthPanelUI.createUI(jComponent);
        }
        if (string == "PasswordFieldUI") {
            return SynthPasswordFieldUI.createUI(jComponent);
        }
        if (string == "PopupMenuSeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "PopupMenuUI") {
            return SynthPopupMenuUI.createUI(jComponent);
        }
        if (string == "ProgressBarUI") {
            return SynthProgressBarUI.createUI(jComponent);
        }
        if (string == "RadioButtonUI") {
            return SynthRadioButtonUI.createUI(jComponent);
        }
        if (string == "RadioButtonMenuItemUI") {
            return SynthRadioButtonMenuItemUI.createUI(jComponent);
        }
        if (string == "RootPaneUI") {
            return SynthRootPaneUI.createUI(jComponent);
        }
        if (string == "ScrollBarUI") {
            return SynthScrollBarUI.createUI(jComponent);
        }
        if (string == "ScrollPaneUI") {
            return SynthScrollPaneUI.createUI(jComponent);
        }
        if (string == "SeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "SliderUI") {
            return SynthSliderUI.createUI(jComponent);
        }
        if (string == "SpinnerUI") {
            return SynthSpinnerUI.createUI(jComponent);
        }
        if (string == "SplitPaneUI") {
            return SynthSplitPaneUI.createUI(jComponent);
        }
        if (string == "TabbedPaneUI") {
            return SynthTabbedPaneUI.createUI(jComponent);
        }
        if (string == "TableUI") {
            return SynthTableUI.createUI(jComponent);
        }
        if (string == "TableHeaderUI") {
            return SynthTableHeaderUI.createUI(jComponent);
        }
        if (string == "TextAreaUI") {
            return SynthTextAreaUI.createUI(jComponent);
        }
        if (string == "TextFieldUI") {
            return SynthTextFieldUI.createUI(jComponent);
        }
        if (string == "TextPaneUI") {
            return SynthTextPaneUI.createUI(jComponent);
        }
        if (string == "ToggleButtonUI") {
            return SynthToggleButtonUI.createUI(jComponent);
        }
        if (string == "ToolBarSeparatorUI") {
            return SynthSeparatorUI.createUI(jComponent);
        }
        if (string == "ToolBarUI") {
            return SynthToolBarUI.createUI(jComponent);
        }
        if (string == "ToolTipUI") {
            return SynthToolTipUI.createUI(jComponent);
        }
        if (string == "TreeUI") {
            return SynthTreeUI.createUI(jComponent);
        }
        if (string == "ViewportUI") {
            return SynthViewportUI.createUI(jComponent);
        }
        return null;
    }

    public void load(InputStream inputStream, Class<?> clazz) throws ParseException {
        if (clazz == null) {
            throw new IllegalArgumentException("You must supply a valid resource base Class");
        }
        if (this.defaultsMap == null) {
            this.defaultsMap = new HashMap();
        }
        new SynthParser().parse(inputStream, (DefaultSynthStyleFactory)this.factory, null, clazz, this.defaultsMap);
    }

    public void load(URL uRL) throws ParseException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("You must supply a valid Synth set URL");
        }
        if (this.defaultsMap == null) {
            this.defaultsMap = new HashMap();
        }
        InputStream inputStream = uRL.openStream();
        new SynthParser().parse(inputStream, (DefaultSynthStyleFactory)this.factory, uRL, null, this.defaultsMap);
    }

    @Override
    public void initialize() {
        super.initialize();
        DefaultLookup.setDefaultLookup(new SynthDefaultLookup());
        SynthLookAndFeel.setStyleFactory(this.factory);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this._handler);
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this._handler);
        super.uninitialize();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults(60, 0.75f);
        Region.registerUIs(uIDefaults);
        uIDefaults.setDefaultLocale(Locale.getDefault());
        uIDefaults.addResourceBundle("com.sun.swing.internal.plaf.basic.resources.basic");
        uIDefaults.addResourceBundle("com.sun.swing.internal.plaf.synth.resources.synth");
        uIDefaults.put("TabbedPane.isTabRollover", Boolean.TRUE);
        uIDefaults.put("ColorChooser.swatchesRecentSwatchSize", new Dimension(10, 10));
        uIDefaults.put("ColorChooser.swatchesDefaultRecentColor", Color.RED);
        uIDefaults.put("ColorChooser.swatchesSwatchSize", new Dimension(10, 10));
        uIDefaults.put("PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"});
        uIDefaults.put("PopupMenu.selectedWindowInputMapBindings.RightToLeft", new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"});
        SynthLookAndFeel.flushUnreferenced();
        Object object = SynthLookAndFeel.getAATextInfo();
        uIDefaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, object);
        new AATextListener(this);
        if (this.defaultsMap != null) {
            uIDefaults.putAll(this.defaultsMap);
        }
        return uIDefaults;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Synth look and feel";
    }

    @Override
    public String getName() {
        return "Synth look and feel";
    }

    @Override
    public String getID() {
        return "Synth";
    }

    public boolean shouldUpdateStyleOnAncestorChanged() {
        return false;
    }

    private static Object getAATextInfo() {
        String string = Locale.getDefault().getLanguage();
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.desktop"));
        boolean bl = Locale.CHINESE.getLanguage().equals(string) || Locale.JAPANESE.getLanguage().equals(string) || Locale.KOREAN.getLanguage().equals(string);
        boolean bl2 = "gnome".equals(string2);
        boolean bl3 = SwingUtilities2.isLocalDisplay();
        boolean bl4 = bl3 && (!bl2 || !bl);
        SwingUtilities2.AATextInfo aATextInfo = SwingUtilities2.AATextInfo.getAATextInfo(bl4);
        return aATextInfo;
    }

    private static void flushUnreferenced() {
        AATextListener aATextListener;
        while ((aATextListener = (AATextListener)queue.poll()) != null) {
            aATextListener.dispose();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException(this.getClass().getName());
    }

    static {
        queue = new ReferenceQueue();
    }

    private static class AATextListener
    extends WeakReference
    implements PropertyChangeListener {
        private String key = "awt.font.desktophints";
        private static boolean updatePending;

        AATextListener(LookAndFeel lookAndFeel) {
            super(lookAndFeel, queue);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addPropertyChangeListener(this.key, this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
            if (uIDefaults.getBoolean("Synth.doNotSetTextAA")) {
                this.dispose();
                return;
            }
            LookAndFeel lookAndFeel = (LookAndFeel)this.get();
            if (lookAndFeel == null || lookAndFeel != UIManager.getLookAndFeel()) {
                this.dispose();
                return;
            }
            Object object = SynthLookAndFeel.getAATextInfo();
            uIDefaults.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, object);
            this.updateUI();
        }

        void dispose() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.removePropertyChangeListener(this.key, this);
        }

        private static void updateWindowUI(Window window) {
            SynthLookAndFeel.updateStyles(window);
            Window[] windowArray = window.getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                AATextListener.updateWindowUI(windowArray[i]);
            }
        }

        private static void updateAllUIs() {
            Frame[] frameArray = Frame.getFrames();
            for (int i = 0; i < frameArray.length; ++i) {
                AATextListener.updateWindowUI(frameArray[i]);
            }
        }

        private static synchronized void setUpdatePending(boolean bl) {
            updatePending = bl;
        }

        private static synchronized boolean isUpdatePending() {
            return updatePending;
        }

        protected void updateUI() {
            if (!AATextListener.isUpdatePending()) {
                AATextListener.setUpdatePending(true);
                Runnable runnable = new Runnable(){

                    public void run() {
                        AATextListener.updateAllUIs();
                        AATextListener.setUpdatePending(false);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if ("focusOwner" == string) {
                if (object2 instanceof JComponent) {
                    this.repaintIfBackgroundsDiffer((JComponent)object2);
                }
                if (object instanceof JComponent) {
                    this.repaintIfBackgroundsDiffer((JComponent)object);
                }
            } else if ("managingFocus" == string) {
                KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)propertyChangeEvent.getSource();
                if (((Boolean)object).equals(Boolean.FALSE)) {
                    keyboardFocusManager.removePropertyChangeListener(SynthLookAndFeel.this._handler);
                } else {
                    keyboardFocusManager.addPropertyChangeListener(SynthLookAndFeel.this._handler);
                }
            }
        }

        private void repaintIfBackgroundsDiffer(JComponent jComponent) {
            ComponentUI componentUI = (ComponentUI)jComponent.getClientProperty(SwingUtilities2.COMPONENT_UI_PROPERTY_KEY);
            if (componentUI instanceof SynthUI) {
                SynthUI synthUI = (SynthUI)((Object)componentUI);
                SynthContext synthContext = synthUI.getContext(jComponent);
                SynthStyle synthStyle = synthContext.getStyle();
                int n = synthContext.getComponentState();
                Color color = synthStyle.getColor(synthContext, ColorType.BACKGROUND);
                synthContext.setComponentState(n ^= 0x100);
                Color color2 = synthStyle.getColor(synthContext, ColorType.BACKGROUND);
                synthContext.setComponentState(n ^= 0x100);
                if (color != null && !color.equals(color2)) {
                    jComponent.repaint();
                }
                synthContext.dispose();
            }
        }
    }
}

