/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.peer.CanvasPeer;
import java.lang.reflect.Method;
import sun.awt.AWTAccessor;
import sun.awt.Graphics2Delegate;
import sun.awt.PaintEventDispatcher;
import sun.awt.SunToolkit;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;

class WCanvasPeer
extends WComponentPeer
implements CanvasPeer {
    private boolean eraseBackground;
    Method resetGCMethod;

    WCanvasPeer(Component component) {
        super(component);
        if (AWTAccessor.getComponentAccessor().getBackgroundEraseDisabled(component)) {
            this.disableBackgroundErase();
        }
    }

    public void displayChanged() {
        this.clearLocalGC();
        this.resetTargetGC();
        super.displayChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTargetGC() {
        WCanvasPeer wCanvasPeer = this;
        synchronized (wCanvasPeer) {
            if (this.resetGCMethod == null) {
                this.resetGCMethod = WToolkit.getMethod(Component.class, "resetGC", null);
            }
        }
        try {
            this.resetGCMethod.invoke(this.target, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void clearLocalGC() {
        this.winGraphicsConfig = null;
    }

    native void create(WComponentPeer var1);

    void initialize() {
        this.eraseBackground = !SunToolkit.getSunAwtNoerasebackground();
        boolean bl = SunToolkit.getSunAwtErasebackgroundonresize();
        if (!PaintEventDispatcher.getPaintEventDispatcher().shouldDoNativeBackgroundErase((Component)this.target)) {
            this.eraseBackground = false;
        }
        this.setNativeBackgroundErase(this.eraseBackground, bl);
        super.initialize();
        Color color = ((Component)this.target).getBackground();
        if (color != null) {
            this.setBackground(color);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = ((Component)this.target).getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(((Component)this.target).getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(((Component)this.target).getForeground());
        }
        super.paint(graphics);
    }

    public void print(Graphics graphics) {
        if (!(this.target instanceof Window) || AWTAccessor.getWindowAccessor().isOpaque((Window)this.target)) {
            Dimension dimension = ((Component)this.target).getSize();
            if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
                graphics.clearRect(0, 0, dimension.width, dimension.height);
            } else {
                graphics.setColor(((Component)this.target).getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(((Component)this.target).getForeground());
            }
        }
        super.print(graphics);
    }

    public boolean shouldClearRectBeforePaint() {
        return this.eraseBackground;
    }

    void disableBackgroundErase() {
        this.eraseBackground = false;
        this.setNativeBackgroundErase(false, false);
    }

    private native void setNativeBackgroundErase(boolean var1, boolean var2);
}

