/*
 * Decompiled with CFR 0.152.
 */
package com.icaste.USBTester;

import com.icaste.JCommUSB_2_0.USBDevice;

public class USBTester {
    public static void main(String[] args) {
        new USBTester();
    }

    public USBTester() {
        System.out.println("Start USBTester!");
        int i = 0;
        String szPath = "";
        try {
            i = USBDevice.getNumAttachedDevices();
            szPath = USBDevice.getAttachedDevicePath(0);
            System.out.println("Device Path of Device at index 0 = " + szPath);
            USBDevice myUSB = new USBDevice(szPath);
            System.out.println("\n\nDevice Desc Data\n");
            System.out.println("Device Class " + myUSB.getDeviceClass());
            System.out.println("Device Sub Class " + myUSB.getDeviceSubClass());
            System.out.println("Device E0 max packet size " + myUSB.getDeviceE0MaxPacketSize());
            System.out.println("Device Manufacturer String index " + myUSB.getDeviceManufacturerStringIndex());
            if (myUSB.getDeviceManufacturerStringIndex() > 0) {
                System.out.println(myUSB.queryString(myUSB.getDeviceManufacturerStringIndex(), (short)1033));
            }
            System.out.println("Device Num Configs " + myUSB.getDeviceNumConfigs());
            System.out.println("Device Vendor ID " + myUSB.getDeviceVendorID());
            System.out.println("Device Product ID " + myUSB.getDeviceProductID());
            System.out.println("Device Product String Index " + myUSB.getDeviceProductStringIndex());
            if (myUSB.getDeviceProductStringIndex() > 0) {
                System.out.println(myUSB.queryString(myUSB.getDeviceProductStringIndex(), (short)1033));
            }
            System.out.println("Device Protocol " + myUSB.getDeviceProtocol());
            System.out.println("Device Version " + myUSB.getDeviceVersion());
            System.out.println("Device Serial Number String Index " + myUSB.getDeviceSerialStringIndex());
            if (myUSB.getDeviceSerialStringIndex() > 0) {
                System.out.println(myUSB.queryString(myUSB.getDeviceSerialStringIndex(), (short)1033));
            }
            System.out.println("\n\nConfig Desc Data\n");
            System.out.println("Conf Current Index " + myUSB.getConfigCurrentIndex());
            System.out.println("Conf Max Power " + myUSB.getConfigMaxPower());
            System.out.println("Conf Num Interfaces " + myUSB.getConfigNumInterfaces());
            System.out.println("Conf String Desc Index " + myUSB.getConfigStringDescIndex());
            if (myUSB.getConfigStringDescIndex() > 0) {
                System.out.println(myUSB.queryString(myUSB.getConfigStringDescIndex(), (short)1033));
            }
            int numInterfaces = myUSB.getConfigNumInterfaces();
            for (i = 0; i < numInterfaces; ++i) {
                System.out.println("\n\nInterface Index " + i + " Current Setting " + myUSB.getInterfaceCurrentSetting(i));
                int iNumSettings = myUSB.getInterfaceNumAlternateSettings(i);
                for (int p = 0; p < iNumSettings; ++p) {
                    System.out.println("Interface Data for Interface index " + i + ", Setting Index " + p);
                    System.out.println("Interface Class " + myUSB.getInterfaceClass(i, p));
                    System.out.println("Interface SubClass " + myUSB.getInterfaceSubClass(i, p));
                    System.out.println("Interface Num Alternate Settings " + myUSB.getInterfaceNumAlternateSettings(i));
                    System.out.println("Interface Num Endpoints " + myUSB.getInterfaceNumEndpoints(i, p));
                    System.out.println("Interface Protocol " + myUSB.getInterfaceProtocol(i, p));
                    System.out.println("Interface String Index " + myUSB.getInterfaceStringIndex(i, p));
                    if (myUSB.getInterfaceStringIndex(i, 0) > 0) {
                        System.out.println(myUSB.queryString(myUSB.getInterfaceStringIndex(i, p), (short)1033));
                    }
                    int iEndpoints = myUSB.getInterfaceNumEndpoints(i, p);
                    System.out.println("");
                    for (int q = 0; q < iEndpoints; ++q) {
                        System.out.println("Endpoint Info for Interface Index " + i + ", Setting Index " + p + ", Endpoint Index " + q);
                        System.out.println("Endpoint Address " + myUSB.getEndpointAddress(i, p, q));
                        System.out.println("Endpoint Interval " + myUSB.getEndpointInterval(i, p, q));
                        System.out.println("Endpoint MaxPacket Size " + myUSB.getEndpointMaxPacketSize(i, p, q));
                        System.out.println("Endpoint Pipe Type: " + myUSB.getEndpointPipeType(i, p, q));
                        switch (myUSB.getEndpointPipeType(i, p, q)) {
                            case 3: {
                                System.out.println("BULK PIPE");
                                break;
                            }
                            case 0: {
                                System.out.println("INVALID PIPE");
                                break;
                            }
                            case 4: {
                                System.out.println("INTERRUPT PIPE");
                                break;
                            }
                            case 2: {
                                System.out.println("ISOCHRONOUS PIPE");
                                break;
                            }
                            case 1: {
                                System.out.println("CONTROL PIPE");
                            }
                        }
                        System.out.println("");
                    }
                }
            }
            System.out.println("\n\nOther Data\n");
            short[] myLangs = myUSB.getSupportedLangIDs();
            System.out.println("Supported Languages");
            for (i = 0; i < myLangs.length; ++i) {
                System.out.println("LangID " + i + " " + myLangs[i]);
            }
            System.out.println("ReadWrite Time Out " + myUSB.getReadWriteTimeOut());
            System.out.println("Control Time Out " + myUSB.getControlTimeOut());
            System.out.println("Max Iso Frame Range = " + myUSB.getDeviceIsochronousMaxFrameOffset());
            System.out.println("\nEND!\n");
        }
        catch (Exception e) {
            System.out.println("Exception!! " + e.getMessage());
        }
    }
}

