/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import com.sun.deploy.net.CrossDomainXML;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.Trace;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import sun.applet.AppletSecurity;
import sun.awt.AppContext;

public class ActivatorSecurityManager
extends AppletSecurity {
    private final Set lockedThreadGroup = new HashSet();

    public void checkAwtEventQueueAccess() {
        try {
            super.checkAwtEventQueueAccess();
            return;
        }
        catch (SecurityException securityException) {
            this.checkSecurityAccess("accessEventQueue");
            return;
        }
    }

    public void checkSecurityAccess(String string) {
        if (string != null && string.equals("java")) {
            return;
        }
        super.checkSecurityAccess(string);
    }

    public void checkPrintJobAccess() {
        try {
            super.checkPrintJobAccess();
            return;
        }
        catch (SecurityException securityException) {
            new CheckPrint_1_2();
            return;
        }
    }

    void showPrintDialog() {
        AppContext appContext = AppContext.getAppContext();
        String string = ResourceManager.getString((String)"plugin.print.title");
        String string2 = ResourceManager.getString((String)"plugin.print.message");
        String string3 = ResourceManager.getString((String)"plugin.print.always");
        String string4 = (String)appContext.get("sun.plugin.security.printDialog");
        int n = 0;
        if (!Trace.isAutomationEnabled() && string4 == null) {
            n = UIFactory.showApiDialog(null, null, (String)string, (String)string2, null, null, (String)string3, (boolean)false);
        } else {
            Trace.msgSecurityPrintln((String)"securitymgr.automation.printing");
            n = 0;
        }
        if (n == 2) {
            appContext.put("sun.plugin.security.printDialog", "skip");
        } else if (n != 0) {
            throw new SecurityException("checkPrintJobAccess");
        }
    }

    public Class[] getExecutionStackContext() {
        return super.getClassContext();
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
        super.checkAccess(threadGroup);
        if (threadGroup.parentOf(Thread.currentThread().getThreadGroup()) && this.lockedThreadGroup.contains(threadGroup)) {
            throw new IllegalThreadStateException("forbid thread creation in disposed TG");
        }
    }

    public synchronized void lockThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            this.lockedThreadGroup.add(threadGroup);
        }
    }

    public synchronized void unlockThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup != null) {
            this.lockedThreadGroup.remove(threadGroup);
        }
    }

    public void checkConnect(String string, int n) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new SecurityException("host syntax error in crossdomain.xml check");
            }
        }
        if (CrossDomainXML.quickCheck((URL)uRL, (String)string, (int)n, (int)n2)) {
            return;
        }
        try {
            super.checkConnect(string, n);
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])this.getClassContext(), (URL)uRL, (String)string, (int)n, (int)n2)) {
                return;
            }
            throw securityException;
        }
    }

    public void checkConnect(String string, int n, Object object) {
        int n2;
        URL uRL = null;
        int n3 = n2 = n < 0 ? n : -4;
        if (n2 == -2 || n2 == -3) {
            try {
                uRL = new URL(string);
                string = uRL.getHost();
                n = uRL.getPort();
                if (n == -1) {
                    n = uRL.getDefaultPort();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new SecurityException("host syntax error in crossdomain.xml check");
            }
        }
        if (CrossDomainXML.quickCheck((URL)uRL, (String)string, (int)n, (int)n2)) {
            return;
        }
        try {
            super.checkConnect(string, n, object);
        }
        catch (SecurityException securityException) {
            if (CrossDomainXML.check((Class[])this.getClassContext(), (URL)uRL, (String)string, (int)n, (int)n2)) {
                return;
            }
            throw securityException;
        }
    }

    private class CheckPrint_1_2
    implements PrivilegedAction {
        CheckPrint_1_2() {
            AccessController.doPrivileged(this);
        }

        public Object run() {
            ActivatorSecurityManager.this.showPrintDialog();
            return null;
        }
    }
}

