/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.perf.DeployPerfUtil;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.StringQuoteUtil;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.CacheUpdateHelper;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.exceptions.CacheAccessException;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JRESelectException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.NoLocalJREException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.ui.SecureStaticVersioning;
import com.sun.javaws.util.JavawsDialogListener;
import com.sun.jnlp.JnlpLookupStub;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jnlp.ServiceManager;
import javax.jnlp.ServiceManagerStub;
import sun.plugin2.applet.Applet2ExecutionContext;
import sun.plugin2.applet.JNLP2ClassLoader;
import sun.plugin2.applet.JNLP2Tag;
import sun.plugin2.applet.Plugin2ClassLoader;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.util.SystemUtil;

public class JNLP2Manager
extends Plugin2Manager {
    private URL _initDocumentBaseURL = null;
    private String _initJnlpFile = null;
    private boolean _initialized;
    private JREInfo homeJREInfo = null;
    private URL _codebase = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy = null;
    private LocalApplicationProperties _lap = null;
    private static boolean _environmentInitialized = false;
    private DownloadProgress downloadProgress;
    private static final boolean _INJECT_EXCEPTION_CSTR;
    private static final boolean _INJECT_EXCEPTION_INIT;
    private static final boolean _INJECT_EXCEPTION_LOADJARFILES;
    private static final boolean _INJECT_FOREVER_LOADJARFILES;
    private static final boolean _INJECT_APPLET_RELAUNCH;

    public JNLP2Manager(String string, URL uRL, String string2, boolean bl) throws Exception {
        super(bl);
        this._initDocumentBaseURL = uRL;
        this._initJnlpFile = string2;
        this._initialized = false;
        if (_INJECT_EXCEPTION_CSTR) {
            Exception exception = new Exception("INJECT_JNLP2MANAGER_EXCEPTION_CSTR");
            throw exception;
        }
        if (string == null) {
            this._codebase = URLUtil.getBase((URL)this._initDocumentBaseURL);
            if (DEBUG) {
                System.out.println("   JNLP Codebase (is documentbase): " + this._codebase);
            }
        } else {
            try {
                this._codebase = URLUtil.asPathURL((URL)new URL(string));
                if (DEBUG) {
                    System.out.println("   JNLP Codebase (absolute): " + this._codebase);
                }
            }
            catch (Exception exception) {
                this._codebase = null;
            }
            if (this._codebase == null) {
                try {
                    this._codebase = URLUtil.asPathURL((URL)new URL(URLUtil.getBase((URL)this._initDocumentBaseURL), string));
                    if (DEBUG) {
                        System.out.println("   JNLP Codebase (documentbase+codebase): " + this._codebase);
                    }
                }
                catch (Exception exception) {
                    this._codebase = null;
                }
            }
            if (DEBUG && this._codebase == null) {
                System.out.println("   JNLP Codebase (null)");
            }
        }
        if (DEBUG) {
            Trace.println((String)("new JNLP2Manager: " + this._initJnlpFile + ", codebase: " + this._codebase + ", documentBase: " + this._initDocumentBaseURL), (TraceLevel)TraceLevel.BASIC);
        }
    }

    protected Plugin2ClassLoader newClassLoader() {
        if (null == this._codebase) {
            Exception exception = new Exception("newClassLoader - init failed: _codebase is null");
            Trace.ignoredException((Exception)exception);
            return null;
        }
        return new JNLP2ClassLoader(this._codebase);
    }

    public void initialize() throws Exception {
        super.initialize();
        Plugin2ClassLoader plugin2ClassLoader = this.getAppletClassLoader();
        if (_INJECT_EXCEPTION_INIT) {
            Exception exception = new Exception("INJECT_JNLP2MANAGER_EXCEPTION_INIT");
            throw exception;
        }
        if (!(plugin2ClassLoader instanceof JNLP2ClassLoader)) {
            Exception exception = new Exception("ClassLoader not JNLP2ClassLoader (" + plugin2ClassLoader + ")");
            throw exception;
        }
        if (!this.isAppletRelaunched()) {
            Config.refreshProps();
        }
        this.homeJREInfo = JREInfo.getHomeJRE();
        if (DEBUG && VERBOSE) {
            Trace.println((String)("JNLP2Manager.initialize(): java.home:" + Config.getJavaHome() + ", RUnning JRE: " + this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)"JREInfos");
            JREInfo.traceJREs();
        }
        if (this.homeJREInfo == null) {
            throw new ExitException((Throwable)new Exception("Internal Error: no running JRE"), 3);
        }
        this._launchDesc = LaunchDescFactory.buildDescriptor((String)this._initJnlpFile, (URL)this._codebase, (URL)this._initDocumentBaseURL, (boolean)DEBUG);
        if (null != this._launchDesc && this.redirectLaunchDesc(this._launchDesc, this._initJnlpFile, this._codebase, this._initDocumentBaseURL) && DEBUG) {
            Trace.println((String)("JNLP2Manager.initialize(): JNLP redirect Ref: " + this._launchDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
        }
        if (null == this._launchDesc) {
            Trace.println((String)("JNLP2Manager.initialize(): JNLP not available: " + this._initJnlpFile), (TraceLevel)TraceLevel.BASIC);
            return;
        }
        if (!this._launchDesc.isApplet()) {
            Trace.println((String)("JNLP2Manager.initialize(): JNLP not an applet: " + this._launchDesc), (TraceLevel)TraceLevel.BASIC);
            return;
        }
        if (Environment.isImportMode()) {
            Trace.println((String)("JNLP2Manager.initialize(): JNLP import mode not supported: " + this._launchDesc), (TraceLevel)TraceLevel.BASIC);
            return;
        }
        AppletDesc appletDesc = this._launchDesc.getAppletDescriptor();
        if (null == appletDesc) {
            Exception exception = new Exception("initialize - init failed: AppletDesc is null");
            throw exception;
        }
        this._codebase = this._launchDesc.getCodebase();
        this._initialized = true;
        Applet2ExecutionContext applet2ExecutionContext = this.getAppletExecutionContext();
        applet2ExecutionContext.setAppletParameters(JNLP2Tag.addJNLParams2Map(applet2ExecutionContext.getAppletParameters(), appletDesc));
        this.prepareToLaunch();
        if (null == this._appPolicy) {
            Exception exception = new Exception("initialize - init failed: _appPolicy is null");
            throw exception;
        }
        ((JNLP2ClassLoader)plugin2ClassLoader).initialize(this._launchDesc, this._appPolicy);
    }

    private DownloadProgress getDownloadProgress() {
        if (this.downloadProgress == null) {
            this.downloadProgress = new DownloadProgress();
        }
        return this.downloadProgress;
    }

    protected void loadJarFiles() throws ExitException {
        block9: {
            if (_INJECT_EXCEPTION_LOADJARFILES) {
                ExitException exitException = new ExitException((Throwable)new Exception("INJECT_JNLP2MANAGER_EXCEPTION_LOADJARFILES"), 3);
                throw exitException;
            }
            this.setGrayBoxProgress(0.0f);
            if (!this._initialized) {
                if (null == this._launchDesc) {
                    ExitException exitException = new ExitException((Throwable)new FileNotFoundException("JNLP not available: " + this._initJnlpFile), 3);
                    throw exitException;
                }
                if (!this._launchDesc.isApplet()) {
                    ExitException exitException = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP not an applet", new Exception("JNLP not an applet")), 3);
                    throw exitException;
                }
                if (Environment.isImportMode()) {
                    ExitException exitException = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP import mode not supported", new Exception("JNLP import mode not supported")), 3);
                    throw exitException;
                }
                ExitException exitException = new ExitException((Throwable)new LaunchDescException(this._launchDesc, "JNLP2Manager not initialized", new Exception("JNLP2Manager not initialized")), 3);
                throw exitException;
            }
            try {
                if (_INJECT_FOREVER_LOADJARFILES) {
                    System.out.println("INJECT_JNLP2MANAGER_FOREVER_LOADJARFILES");
                    int n = 999999;
                    while (n > 0) {
                        if (--n >= 999) continue;
                        n = 999999;
                    }
                }
                this.prepareLaunchFile(this._launchDesc);
            }
            catch (Throwable throwable) {
                ExitException exitException;
                ExitException exitException2 = exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                if (exitException.getReason() == 0) break block9;
                throw exitException;
            }
        }
    }

    protected URL getCodeBase() {
        return this._codebase;
    }

    protected String getCode() {
        if (null != this._launchDesc && this._launchDesc.isApplet()) {
            return this._launchDesc.getAppletDescriptor().getAppletClass();
        }
        return "<applet error>";
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    private boolean redirectLaunchDesc(LaunchDesc launchDesc, String string, URL uRL, URL uRL2) throws ExitException {
        try {
            URL uRL3 = this._launchDesc.getLocation();
            if (uRL3 != null) {
                URL uRL4 = null;
                try {
                    uRL4 = new URL(string);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println(exception);
                        exception.printStackTrace();
                    }
                    uRL4 = null;
                }
                if (uRL4 != null && uRL4.toString().equals(uRL3.toString())) {
                    return false;
                }
                if (uRL != null) {
                    try {
                        uRL4 = new URL(uRL, string);
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                        uRL4 = null;
                    }
                    if (uRL4 != null && uRL4.toString().equals(uRL3.toString())) {
                        return false;
                    }
                }
                if (uRL == null && uRL2 != null) {
                    try {
                        uRL4 = new URL(URLUtil.getBase((URL)uRL2), string);
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            System.out.println(exception);
                            exception.printStackTrace();
                        }
                        uRL4 = null;
                    }
                    if (uRL4 != null && uRL4.toString().equals(uRL3.toString())) {
                        return false;
                    }
                }
                this._launchDesc = LaunchDescFactory.buildDescriptor((String)uRL3.toString(), (URL)uRL, (URL)uRL2, (boolean)DEBUG);
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println(exception);
                exception.printStackTrace();
            }
            throw new ExitException((Throwable)exception, 3);
        }
    }

    private void prepareToLaunch() throws ExitException {
        block5: {
            try {
                this._lap = Cache.getLocalApplicationProperties((URL)this._launchDesc.getCanonicalHome());
                URL uRL = this._launchDesc.getLocation();
                if (uRL != null) {
                    Cache.removeRemovedApp((String)uRL.toString(), (String)this._launchDesc.getInformation().getTitle());
                }
                if (this._launchDesc.getResources() != null) {
                    Globals.getDebugOptionsFromProperties((Properties)this._launchDesc.getResources().getResourceProperties());
                }
                this._appPolicy = AppPolicy.createInstance((String)this._launchDesc.getCanonicalHome().getHost());
            }
            catch (Throwable throwable) {
                ExitException exitException = throwable instanceof ExitException ? (ExitException)throwable : new ExitException(throwable, 3);
                int n = exitException.getReason();
                if (n == 3) {
                    this.showAppletException(exitException.getException());
                }
                if (n == 0) break block5;
                throw exitException;
            }
        }
    }

    private void prepareLaunchFile(LaunchDesc launchDesc) throws ExitException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, (Exception)new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.noappresources", (String)launchDesc.getSpecVersion()), null));
        }
        if (!launchDesc.isJRESpecified()) {
            object4 = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.missingjreversion"), null);
            this.handleJnlpFileException(launchDesc, (Exception)object4);
        }
        JNLPException.setDefaultLaunchDesc((LaunchDesc)launchDesc);
        if (!launchDesc.getInformation().supportsOfflineOperation() && DeployOfflineManager.isGlobalOffline()) {
            throw new ExitException((Throwable)new OfflineLaunchException(1), 3);
        }
        object4 = launchDesc.getCanonicalHome();
        if (object4 == null) {
            LaunchDescException launchDescException = new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.nomainjar"), null);
            throw new ExitException((Throwable)launchDescException, 3);
        }
        launchDesc.setPropsSet(true);
        JNLP2ClassLoader jNLP2ClassLoader = (JNLP2ClassLoader)this.getOrCreatePlugin2ClassLoader();
        ArrayList arrayList = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = !launchDesc.getUpdate().isBackgroundCheck() && !launchDesc.getUpdate().isPromptPolicy() && !this.isAppletRelaunched();
        boolean bl4 = false;
        bl4 = this.downloadResources(jNLP2ClassLoader, launchDesc, arrayList, bl3);
        launchDesc.selectJRE();
        if (bl4) {
            this.resetForceUpdateCheck();
        }
        Trace.println((String)("LaunchDesc location: " + object4), (TraceLevel)TraceLevel.BASIC);
        LaunchSelection.MatchJREIf matchJREIf = launchDesc.getJREMatcher();
        if (DEBUG && VERBOSE) {
            Trace.println((String)"JNLP2Manager.prepareLaunchFile: JRE matcher:");
            Trace.println((String)matchJREIf.toString());
        }
        boolean bl5 = matchJREIf.isRunningJVMSatisfying(true);
        boolean bl6 = matchJREIf.getSelectedJVMParameters().isSecure();
        JREInfo jREInfo = launchDesc.getSelectedJRE();
        JREDesc jREDesc = launchDesc.getResources().getSelectedJRE();
        if (jREInfo == null && jREDesc == null) {
            Trace.println((String)matchJREIf.toString());
            throw new ExitException((Throwable)new Exception("Internal Error: Internal error, no JREDesc and no JREInfo"), 3);
        }
        boolean bl7 = jREInfo == null;
        boolean bl8 = DeployOfflineManager.isGlobalOffline();
        if (bl7 && bl8) {
            throw new ExitException((Throwable)new OfflineLaunchException(0), 3);
        }
        boolean bl9 = bl7;
        if (!(bl7 || bl4 || launchDesc.getUpdate().isBackgroundCheck() || this.isAppletRelaunched() || bl8)) {
            if (this._lap != null && this._lap.forceUpdateCheck()) {
                if (DEBUG) {
                    Trace.println((String)"Forced update check in LAP, do full update", (TraceLevel)TraceLevel.BASIC);
                }
                bl9 = true;
            } else {
                bl9 = launchDesc.getUpdater().isUpdateAvailable();
                if (launchDesc.getUpdater().isCheckAborted()) {
                    throw new ExitException((Throwable)new LaunchDescException(launchDesc, "User rejected cert - aborted", null), 4);
                }
            }
        } else {
            launchDesc.getUpdater().startBackgroundUpdateOpt();
        }
        if (DEBUG) {
            Trace.println((String)("\n\tisRelaunch: " + this.isAppletRelaunched() + "\n\tOffline mode: " + bl8 + "\n\tforceUpdate: " + bl7 + "\n\tneedUpdate: " + bl9 + "\n\tbgrUpdCheck: " + launchDesc.getUpdate().isBackgroundCheck() + "\n\tbgrUpdThread: " + launchDesc.getUpdater().isBackgroundUpdateRunning() + "\n\tRunning  JREInfo: " + this.homeJREInfo + "\n\t" + matchJREIf), (TraceLevel)TraceLevel.BASIC);
        }
        if (bl9 && !bl7) {
            bl7 = launchDesc.getUpdater().needUpdatePerPolicy();
        }
        if (bl7) {
            if (!this.isAppletRelaunched() && jREInfo == null) {
                this.downloadJREResource(launchDesc, jREDesc, arrayList, this.getDownloadProgress());
                if (!arrayList.isEmpty()) {
                    try {
                        JnlpxArgs.executeInstallers(arrayList, (LaunchDownload.DownloadProgressWindow)this.getDownloadProgress());
                    }
                    catch (ExitException exitException) {
                        boolean bl10 = bl2 = exitException.getReason() == 1;
                        if (!bl2 && exitException.isErrorException()) {
                            throw new ExitException(null, 0);
                        }
                        Trace.ignoredException((Exception)((Object)exitException));
                    }
                    if (!this.isValidSpecificationVersion(launchDesc)) {
                        Config.getInstance().resetJavaHome();
                    }
                }
                object3 = Config.getJavaHome() + File.separator + "bin" + File.separator;
                Config.getInstance().notifyJREInstalled((String)object3);
                bl = true;
            } else {
                this.downloadResources(jNLP2ClassLoader, launchDesc, arrayList, true);
            }
            this.resetForceUpdateCheck();
        }
        if (bl && bl5) {
            throw new ExitException((Throwable)new Exception("Internal Error: jreInstalled, but homeJVM matches"), 3);
        }
        if (bl5) {
            if (DEBUG && VERBOSE) {
                Trace.println((String)("JNLP2Manager.prepareLaunchFile(): SingleInstanceManager ?: " + launchDesc.getCanonicalHome().toString()));
            }
            if (SingleInstanceManager.isServerRunning((String)launchDesc.getCanonicalHome().toString())) {
                object3 = Globals.getApplicationArgs();
                if (DEBUG && VERBOSE) {
                    Trace.println((String)("JNLP2Manager.prepareLaunchFile(): SingleInstanceManager: Running with appArgs: " + object3 + ", thread: " + Thread.currentThread()));
                }
                if (object3 != null) {
                    launchDesc.getApplicationDescriptor().setArguments(object3);
                }
                if (SingleInstanceManager.connectToServer((String)launchDesc.toString())) {
                    if (DEBUG && VERBOSE) {
                        Trace.println((String)"JNLP2Manager.prepareLaunchFile(): SingleInstanceManager: OK from server");
                    }
                    String string = "Single Instance already exist: " + launchDesc.getCanonicalHome().toString();
                    Exception exception = new Exception(string);
                    this.setErrorOccurred(string, exception);
                    throw new ExitException((Throwable)exception, 5);
                }
                if (DEBUG && VERBOSE) {
                    Trace.println((String)"JNLP2Manager.prepareLaunchFile(): SingleInstanceManager: NOK from server");
                }
            } else if (DEBUG && VERBOSE) {
                Trace.println((String)("JNLP2Manager.prepareLaunchFile(): No SingleInstanceManager, thread: " + Thread.currentThread()));
            }
            if (!arrayList.isEmpty()) {
                try {
                    JnlpxArgs.executeInstallers(arrayList, (LaunchDownload.DownloadProgressWindow)this.getDownloadProgress());
                }
                catch (ExitException exitException) {
                    if (exitException.getReason() != 1) {
                        throw exitException;
                    }
                    bl2 = true;
                }
            }
        }
        if (!this.isValidSpecificationVersion(launchDesc)) {
            JNLPException.setDefaultLaunchDesc((LaunchDesc)launchDesc);
            this.handleJnlpFileException(launchDesc, (Exception)new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.badjnlversion", (String)launchDesc.getSpecVersion()), null));
        }
        if (launchDesc.isSecureJVMArgs() && (bl2 || !bl5) || _INJECT_APPLET_RELAUNCH) {
            if (bl) {
                this.setParameter("__jre_installed", String.valueOf(true));
            }
            if (DEBUG) {
                Trace.println((String)("JRESelectException(1): installerRelaunch: " + bl2), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException(1): jreInstalled: " + bl), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException(1): running JREInfo: " + this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException(1): " + matchJREIf), (TraceLevel)TraceLevel.BASIC);
            }
            if (!this.isAppletRelaunched()) {
                object3 = matchJREIf.getSelectedJVMParameters().getCommandLineArguments(false, false, false, false, Config.getMaxCommandLineLength());
                object2 = StringQuoteUtil.getStringByCommandList((List)object3);
                if (this.fireAppletRelaunchSupported()) {
                    throw new JRESelectException(jREDesc, (String)object2);
                }
                Trace.println((String)"JRESelectException(1): ignored - relaunch not supported", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.println((String)"JRESelectException(1): ignored - relaunched already", (TraceLevel)TraceLevel.BASIC);
            }
        }
        boolean bl11 = false;
        try {
            bl11 = LaunchDownload.checkSignedResources((LaunchDesc)launchDesc);
            LaunchDownload.checkSignedLaunchDesc((LaunchDesc)launchDesc);
            bl11 = bl11 && launchDesc.isSigned();
        }
        catch (JNLPException jNLPException) {
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException((Throwable)iOException, 3);
        }
        catch (Exception exception) {
            throw new ExitException((Throwable)exception, 3);
        }
        Trace.println((String)("passing security checks; secureArgs:" + launchDesc.isSecureJVMArgs() + ", allSigned:" + bl11), (TraceLevel)TraceLevel.BASIC);
        bl5 = matchJREIf.isRunningJVMSatisfying(bl11);
        if (bl2 || !bl5 || _INJECT_APPLET_RELAUNCH) {
            if (bl) {
                this.setParameter("__jre_installed", String.valueOf(true));
            }
            if (DEBUG) {
                Trace.println((String)("JRESelectException(2): installerRelaunch: " + bl2), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException(2): jreInstalled: " + bl), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException(2): running JREInfo: " + this.homeJREInfo), (TraceLevel)TraceLevel.BASIC);
                Trace.println((String)("JRESelectException(2): " + matchJREIf), (TraceLevel)TraceLevel.BASIC);
            }
            if (!this.isAppletRelaunched()) {
                object2 = matchJREIf.getSelectedJVMParameters().getCommandLineArguments(false, false, false, bl11, Config.getMaxCommandLineLength());
                object = StringQuoteUtil.getStringByCommandList((List)object2);
                if (this.fireAppletRelaunchSupported()) {
                    throw new JRESelectException(jREDesc, (String)object);
                }
                Trace.println((String)"JRESelectException(2): ignored - relaunch not supported", (TraceLevel)TraceLevel.BASIC);
            } else {
                Trace.println((String)"JRESelectException(2): ignored - relaunched already", (TraceLevel)TraceLevel.BASIC);
            }
        }
        Trace.println((String)"continuing launch in this VM", (TraceLevel)TraceLevel.BASIC);
        object2 = launchDesc.getResources();
        if (object2 != null) {
            object = object2.getEagerOrAllJarDescs(true);
            for (int i = 0; i < ((JARDesc[])object).length; ++i) {
                this.storeJarVersionMapInAppContext(object[i]);
            }
        }
    }

    private boolean downloadResources(JNLP2ClassLoader jNLP2ClassLoader, LaunchDesc launchDesc, ArrayList arrayList, boolean bl) throws ExitException {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        if (!bl) {
            try {
                bl3 = LaunchDownload.isInCache((LaunchDesc)launchDesc);
            }
            catch (Exception exception) {
                Trace.ignoredException((Exception)exception);
            }
            boolean bl5 = bl4 = !bl3;
        }
        if (DEBUG) {
            Trace.println((String)("JNLP2Manager.downloadResources(): updateCache " + bl + ", allInCache " + bl3 + ", doDownload " + bl4), (TraceLevel)TraceLevel.BASIC);
        }
        if (!bl4) {
            return bl2;
        }
        try {
            LaunchDownload.downloadExtensions((LaunchDesc)launchDesc, (LaunchDownload.DownloadProgress)this.getDownloadProgress(), (int)0, (ArrayList)arrayList);
            jNLP2ClassLoader.updateJarDescriptors(launchDesc.getResources());
            LaunchDownload.downloadEagerorAll((LaunchDesc)launchDesc, (boolean)false, (LaunchDownload.DownloadProgress)this.getDownloadProgress(), (boolean)false);
            bl2 = true;
        }
        catch (SecurityException securityException) {
            throw new ExitException((Throwable)securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (IOException iOException) {
            throw new ExitException((Throwable)iOException, 3);
        }
        return bl2;
    }

    private void resetForceUpdateCheck() {
        if (this._lap != null && this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(false);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private void setForceUpdateCheck() {
        if (this._lap != null && !this._lap.forceUpdateCheck()) {
            this._lap.setForceUpdateCheck(true);
            try {
                this._lap.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) throws ExitException {
        DownloadEngine.removeCachedResource((URL)launchDesc.getCanonicalHome(), null, null);
        throw new ExitException((Throwable)exception, 3);
    }

    private boolean isValidSpecificationVersion(LaunchDesc launchDesc) {
        VersionString versionString = new VersionString(launchDesc.getSpecVersion());
        return versionString.contains(new VersionID("6.0")) || versionString.contains(new VersionID("1.5")) || versionString.contains(new VersionID("1.0"));
    }

    private void downloadJREResource(LaunchDesc launchDesc, JREDesc jREDesc, ArrayList arrayList, LaunchDownload.DownloadProgressWindow downloadProgressWindow) throws ExitException {
        String string;
        boolean bl;
        Trace.println((String)"downloadJREResource ...", (TraceLevel)TraceLevel.BASIC);
        String string2 = Config.getProperty((String)"deployment.javaws.autodownload");
        if (string2 != null && string2.equalsIgnoreCase("NEVER")) {
            throw new ExitException((Throwable)new NoLocalJREException(launchDesc, jREDesc.getVersion(), false), 3);
        }
        String string3 = jREDesc.getSource();
        URL uRL = jREDesc.getHref();
        boolean bl2 = bl = uRL == null;
        if (bl) {
            string = Config.getProperty((String)"deployment.javaws.installURL");
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ExitException((Throwable)malformedURLException, 3);
            }
        }
        if ((string = DownloadEngine.getAvailableVersion((URL)uRL, (String)jREDesc.getVersion(), (boolean)bl, (String)JREInfo.getKnownPlatforms())) == null) {
            string = jREDesc.getVersion();
        }
        if (SecureStaticVersioning.promptRequired((LaunchDesc)launchDesc, (LocalApplicationProperties)this._lap, (boolean)true, (String)string) ? !SecureStaticVersioning.promptDownload((Component)downloadProgressWindow.getOwner(), (LaunchDesc)launchDesc, (LocalApplicationProperties)this._lap, (String)string, (String)string3) : string2 != null && string2.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt((Component)downloadProgressWindow.getOwner(), (LaunchDesc)launchDesc)) {
            throw new ExitException(null, 0);
        }
        downloadProgressWindow.setProgressBarVisible(true);
        downloadProgressWindow.setVisible(true);
        try {
            if (!Cache.isCacheEnabled()) {
                throw new IOException("Cache disabled, cannot download JRE");
            }
            LaunchDownload.downloadJRE((LaunchDesc)launchDesc, (LaunchDownload.DownloadProgress)downloadProgressWindow, (ArrayList)arrayList);
        }
        catch (SecurityException securityException) {
            throw new ExitException((Throwable)securityException, 3);
        }
        catch (JNLPException jNLPException) {
            throw new ExitException((Throwable)jNLPException, 3);
        }
        catch (Exception exception) {
            Trace.ignored((Throwable)exception);
            throw new ExitException((Throwable)new NoLocalJREException(launchDesc, launchDesc.getResources().getSelectedJRE().getVersion(), false), 3);
        }
        Trace.println((String)"downloadJREResource fin", (TraceLevel)TraceLevel.BASIC);
    }

    private void storeJarVersionMapInAppContext(JARDesc jARDesc) {
        if (null == jARDesc || null == this.appletAppContext) {
            return;
        }
        URL uRL = jARDesc.getLocation();
        if (uRL != null) {
            this.appletAppContext.put(Config.getAppContextKeyPrefix() + uRL.toString(), jARDesc.getVersion());
        }
    }

    protected String getJarFiles() {
        if (!this._initialized) {
            return null;
        }
        ResourcesDesc resourcesDesc = this._launchDesc.getResources();
        if (resourcesDesc != null) {
            return JNLP2Manager.buildJarList(resourcesDesc.getEagerOrAllJarDescs(true));
        }
        return null;
    }

    protected static String buildJarList(JARDesc[] jARDescArray) {
        if (jARDescArray == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        boolean bl = false;
        for (int i = 0; i < jARDescArray.length; ++i) {
            String string = jARDescArray[i].toString();
            if (string == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string);
            bl = true;
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static void initializeExecutionEnvironment() throws JNLPException {
        if (_environmentInitialized) {
            return;
        }
        long l = DeployPerfUtil.put((long)0L, (String)"JNLP2Manager - initializeExecutionEnvironment() - BEGIN");
        if (!Cache.canWrite()) {
            CacheAccessException cacheAccessException = new CacheAccessException(Environment.isSystemCacheMode());
            throw cacheAccessException;
        }
        Properties properties = System.getProperties();
        properties.setProperty("javawebstart.version", Globals.getComponentName());
        ServiceManager.setServiceManagerStub((ServiceManagerStub)new JnlpLookupStub());
        Config.setupPackageAccessRestriction();
        UIFactory.setDialogListener((DialogListener)new JavawsDialogListener());
        if (DeployOfflineManager.isGlobalOffline()) {
            try {
                if (!DeployOfflineManager.askUserGoOnline((URL)new URL("http://java.sun.com"))) {
                    DeployOfflineManager.setForcedOffline((boolean)true);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (Environment.isSystemCacheMode()) {
            CacheUpdateHelper.systemUpdateCheck();
        } else if (Config.getBooleanProperty((String)"deployment.javaws.cache.update") && CacheUpdateHelper.updateCache()) {
            Config.setBooleanProperty((String)"deployment.javaws.cache.update", (boolean)false);
            Config.storeIfDirty();
        }
        if (Globals.TCKHarnessRun) {
            JNLP2Manager.tckprintln("Java Started");
        }
        _environmentInitialized = true;
        DeployPerfUtil.put((long)l, (String)"JNLP2Manager - initializeExecutionEnvironment() - END");
    }

    protected boolean useGrayBoxProgressListener() {
        return false;
    }

    public static synchronized void tckprintln(String string) {
        long l = System.currentTimeMillis();
        Trace.println((String)("##TCKHarnesRun##:" + l + ":" + Runtime.getRuntime().hashCode() + ":" + Thread.currentThread() + ":" + string));
    }

    public void installShortcuts() {
        this.startWorkerThread("Shortcut Installer Thread", new Runnable(){

            public void run() {
                URL uRL = JNLP2Manager.this._launchDesc.getLocation();
                LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
                if (localApplicationProperties != null) {
                    LocalInstallHandler localInstallHandler;
                    localApplicationProperties.setLastAccessed(new Date());
                    localApplicationProperties.incrementLaunchCount();
                    localApplicationProperties.setDraggedApplet();
                    if (JNLP2Manager.this._initDocumentBaseURL != null) {
                        localApplicationProperties.setDocumentBase(JNLP2Manager.this._initDocumentBaseURL.toString());
                    }
                    if (JNLP2Manager.this._codebase != null) {
                        localApplicationProperties.setCodebase(JNLP2Manager.this._codebase.toString());
                    }
                    if ((localInstallHandler = LocalInstallHandler.getInstance()) != null && !localInstallHandler.isShortcutExists(localApplicationProperties)) {
                        localApplicationProperties.setAskedForInstall(false);
                        localInstallHandler.install(JNLP2Manager.this._launchDesc, localApplicationProperties, true, false, null);
                    }
                    try {
                        localApplicationProperties.store();
                    }
                    catch (IOException iOException) {
                        Trace.ignored((Throwable)iOException);
                    }
                }
            }
        });
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string = SystemUtil.getenv("JPI_PLUGIN2_INJECT_JNLP2MANAGER");
        if (null != string) {
            System.out.println("JPI_PLUGIN2_INJECT_JNLP2MANAGER: " + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = new String(stringTokenizer.nextToken());
                    if (null == string2) continue;
                    if (!bl) {
                        bl = "EXCEPTION_CSTR".equals(string2);
                    }
                    if (!bl2) {
                        bl2 = "EXCEPTION_INIT".equals(string2);
                    }
                    if (!bl3) {
                        bl3 = "EXCEPTION_LOADJARFILES".equals(string2);
                    }
                    if (!bl4) {
                        bl4 = "FOREVER_LOADJARFILES".equals(string2);
                    }
                    if (bl5) continue;
                    bl5 = "APPLET_RELAUNCH".equals(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("\tEXCEPTION_CSTR: " + bl);
            System.out.println("\tEXCEPTION_INIT: " + bl2);
            System.out.println("\tEXCEPTION_LOADJARFILES: " + bl3);
            System.out.println("\tFOREVER_LOADJARFILES: " + bl4);
            System.out.println("\tAPPLET_RELAUNCH: " + bl5);
        }
        _INJECT_EXCEPTION_CSTR = bl;
        _INJECT_EXCEPTION_INIT = bl2;
        _INJECT_EXCEPTION_LOADJARFILES = bl3;
        _INJECT_FOREVER_LOADJARFILES = bl4;
        _INJECT_APPLET_RELAUNCH = bl5;
    }

    class DownloadProgress
    implements LaunchDownload.DownloadProgressWindow {
        private Set validatingJars = new HashSet();
        private Set patchingJars = new HashSet();

        DownloadProgress() {
        }

        public void jreDownload(String string, URL uRL) {
            System.out.println("Downloading JRE " + string + " from " + uRL + "...");
        }

        public void extensionDownload(String string, int n) {
        }

        public void progress(URL uRL, String string, long l, long l2, int n) {
            if (l2 != -1L) {
                JNLP2Manager.this.setGrayBoxProgress((float)n / 100.0f);
            }
        }

        public void validating(URL uRL, String string, long l, long l2, int n) {
            if (this.validatingJars.add(uRL)) {
                System.out.println("Validating " + uRL + " , version " + string + "...");
            }
        }

        public void patching(URL uRL, String string, int n, int n2) {
            if (this.patchingJars.add(uRL)) {
                System.out.println("Patching " + uRL + " , version " + string + "...");
            }
        }

        public void downloadFailed(URL uRL, String string) {
            RuntimeException runtimeException = new RuntimeException("Download failed for URL " + uRL + " , version " + string + "...");
            JNLP2Manager.this.showAppletException(runtimeException);
        }

        public void setHeading(String string, boolean bl) {
        }

        public void setStatus(String string) {
        }

        public Component getOwner() {
            return null;
        }

        public void setVisible(boolean bl) {
        }

        public void setProgressBarVisible(boolean bl) {
        }

        public void setProgressBarValue(int n) {
        }

        public void showLaunchingApplication(String string) {
        }
    }
}

