/*
 * Decompiled with CFR 0.152.
 */
package com.icaste.JCommUSB_2_0;

import com.icaste.JCommUSB_2_0.USBException;

public class USBDevice {
    private long iPTR = 0L;
    public static final short BMREQUEST_TO_DEVICE = 0;
    public static final short BMREQUEST_TO_ENDPOINT = 2;
    public static final short BMREQUEST_TO_INTERFACE = 1;
    public static final short BMREQUEST_TO_OTHER = 2;
    public static final byte PIPE_INVALID = 0;
    public static final byte PIPE_CONTROL = 1;
    public static final byte PIPE_ISOCHRONOUS = 2;
    public static final byte PIPE_BULK = 3;
    public static final byte PIPE_INTERRUPT = 4;

    private native long initCPPNat();

    private native void initUSBNat(long var1, String var3) throws USBException;

    private native void destroyCPPNat(long var1);

    private static native int getNumDevsNat() throws USBException;

    private static native String getDevicePathNat(int var0) throws USBException;

    private native int getConfigNumInterfacesNat(long var1) throws USBException;

    private native int getConfigCurrentIndexNat(long var1) throws USBException;

    private native int getConfigStringDescIndexNat(long var1) throws USBException;

    private native byte getConfigAttributesNat(long var1) throws USBException;

    private native int getConfigMaxPowerNat(long var1) throws USBException;

    private native byte getDeviceClassNat(long var1) throws USBException;

    private native byte getDeviceSubClassNat(long var1) throws USBException;

    private native byte getDeviceProtocolNat(long var1) throws USBException;

    private native byte getDeviceE0MaxPacketSizeNat(long var1) throws USBException;

    private native short getDeviceVendorIDNat(long var1) throws USBException;

    private native short getDeviceProductIDNat(long var1) throws USBException;

    private native short getDeviceVersionNat(long var1) throws USBException;

    private native int getDeviceManufacturerStringIndexNat(long var1) throws USBException;

    private native int getDeviceProductStringIndexNat(long var1) throws USBException;

    private native int getDeviceSerialStringIndexNat(long var1) throws USBException;

    private native int getDeviceNumConfigsNat(long var1) throws USBException;

    private native String queryStringNat(long var1, int var3, short var4) throws USBException;

    private native short[] getSupportedLangIDsNat(long var1) throws USBException;

    private native boolean isDeviceConnectedNat(long var1) throws USBException;

    private native boolean resetDeviceNat(long var1) throws USBException;

    private native boolean powerCycleDeviceNat(long var1) throws USBException;

    private native int getInterfaceNumAlternateSettingsNat(long var1, int var3) throws USBException;

    private native int getInterfaceNumFromIndexNat(long var1, int var3) throws USBException;

    private native int getInterfaceNumEndpointsNat(long var1, int var3, int var4) throws USBException;

    private native byte getInterfaceClassNat(long var1, int var3, int var4) throws USBException;

    private native byte getInterfaceSubClassNat(long var1, int var3, int var4) throws USBException;

    private native byte getInterfaceProtocolNat(long var1, int var3, int var4) throws USBException;

    private native int getInterfaceStringIndexNat(long var1, int var3, int var4) throws USBException;

    private native int getInterfaceCurrentSettingNat(long var1, int var3) throws USBException;

    private native boolean setInterfaceCurrentSettingNat(long var1, int var3, int var4) throws USBException;

    private native long readPipeBulkInterruptNat(long var1, int var3, int var4, byte[] var5, long var6, long var8) throws USBException;

    private native long writePipeBulkInterruptNat(long var1, int var3, int var4, byte[] var5, long var6, long var8) throws USBException;

    private native long readPipeIsochronousNat(long var1, int var3, int var4, long var5, long var7, byte[] var9, long var10, long var12) throws USBException;

    private native long writePipeIsochronousNat(long var1, int var3, int var4, long var5, long var7, byte[] var9, long var10, long var12) throws USBException;

    private native long getDeviceIsochronousFrameOffsetNat(long var1) throws USBException;

    private native long writeE0VendorControlNat(long var1, short var3, short var4, short var5, short var6, byte[] var7, long var8, long var10) throws USBException;

    private native long readE0VendorControlNat(long var1, short var3, short var4, short var5, short var6, byte[] var7, long var8, long var10) throws USBException;

    private native long writeE0ClassControlNat(long var1, short var3, short var4, short var5, short var6, byte[] var7, long var8, long var10) throws USBException;

    private native long readE0ClassControlNat(long var1, short var3, short var4, short var5, short var6, byte[] var7, long var8, long var10) throws USBException;

    private native boolean setE0FeatureControlNat(long var1, short var3, short var4, short var5, boolean var6) throws USBException;

    private native short getE0StatusControlNat(long var1, short var3, short var4) throws USBException;

    private native int getEndpointMaxPacketSizeNat(long var1, int var3, int var4, int var5) throws USBException;

    private native byte getEndpointAddressNat(long var1, int var3, int var4, int var5) throws USBException;

    private native byte getEndpointIntervalNat(long var1, int var3, int var4, int var5) throws USBException;

    private native byte getEndpointPipeTypeNat(long var1, int var3, int var4, int var5) throws USBException;

    private native boolean resetPipeNat(long var1, int var3, int var4) throws USBException;

    private native boolean setControlTimeOutNat(long var1, long var3);

    private native boolean setReadWriteTimeOutNat(long var1, long var3);

    private native long getControlTimeOutNat(long var1);

    private native long getReadWriteTimeOutNat(long var1);

    public USBDevice(String szPath) throws USBException {
        try {
            this.iPTR = this.initCPPNat();
            this.initUSBNat(this.iPTR, szPath);
        }
        catch (USBException e) {
            this.destroyCPPNat(this.iPTR);
            throw e;
        }
    }

    public static int getNumAttachedDevices() throws USBException {
        return USBDevice.getNumDevsNat();
    }

    public static String getAttachedDevicePath(int iDeviceIndex) throws USBException {
        return USBDevice.getDevicePathNat(iDeviceIndex);
    }

    protected void finalize() {
        if (this.iPTR != 0L) {
            this.destroyCPPNat(this.iPTR);
        }
    }

    public int getConfigNumInterfaces() throws USBException {
        return this.getConfigNumInterfacesNat(this.iPTR);
    }

    public int getConfigCurrentIndex() throws USBException {
        return this.getConfigCurrentIndexNat(this.iPTR);
    }

    public int getConfigStringDescIndex() throws USBException {
        return this.getConfigStringDescIndexNat(this.iPTR);
    }

    public int getConfigMaxPower() throws USBException {
        return this.getConfigMaxPowerNat(this.iPTR);
    }

    public int getDeviceClass() throws USBException {
        return this.getDeviceClassNat(this.iPTR);
    }

    public int getDeviceSubClass() throws USBException {
        return this.getDeviceSubClassNat(this.iPTR);
    }

    public int getDeviceProtocol() throws USBException {
        return this.getDeviceProtocolNat(this.iPTR);
    }

    public int getDeviceE0MaxPacketSize() throws USBException {
        return this.getDeviceE0MaxPacketSizeNat(this.iPTR);
    }

    public int getDeviceVendorID() throws USBException {
        return this.getDeviceVendorIDNat(this.iPTR);
    }

    public int getDeviceProductID() throws USBException {
        return this.getDeviceProductIDNat(this.iPTR);
    }

    public int getDeviceVersion() throws USBException {
        return this.getDeviceVersionNat(this.iPTR);
    }

    public int getDeviceManufacturerStringIndex() throws USBException {
        return this.getDeviceManufacturerStringIndexNat(this.iPTR);
    }

    public int getDeviceProductStringIndex() throws USBException {
        return this.getDeviceProductStringIndexNat(this.iPTR);
    }

    public int getDeviceSerialStringIndex() throws USBException {
        return this.getDeviceSerialStringIndexNat(this.iPTR);
    }

    public int getDeviceNumConfigs() throws USBException {
        return this.getDeviceNumConfigsNat(this.iPTR);
    }

    public String queryString(int iIndex, short sLangId) throws USBException {
        if (iIndex == 0) {
            throw new USBException("Index 0 not a valid descriptor");
        }
        return this.queryStringNat(this.iPTR, iIndex, sLangId);
    }

    public short[] getSupportedLangIDs() throws USBException {
        return this.getSupportedLangIDsNat(this.iPTR);
    }

    public boolean deviceIsConnected() throws USBException {
        return this.isDeviceConnectedNat(this.iPTR);
    }

    public boolean deviceReset() throws USBException {
        return this.resetDeviceNat(this.iPTR);
    }

    public boolean devicePowerCycle() throws USBException {
        return this.powerCycleDeviceNat(this.iPTR);
    }

    public int getInterfaceNumAlternateSettings(int iIndex) throws USBException {
        return this.getInterfaceNumAlternateSettingsNat(this.iPTR, iIndex);
    }

    public int getInterfaceNumEndpoints(int iIntIndex, int iSetIndex) throws USBException {
        return this.getInterfaceNumEndpointsNat(this.iPTR, iIntIndex, iSetIndex);
    }

    public byte getInterfaceClass(int iIntIndex, int iSetIndex) throws USBException {
        return this.getInterfaceClassNat(this.iPTR, iIntIndex, iSetIndex);
    }

    public byte getInterfaceSubClass(int iIntIndex, int iSetIndex) throws USBException {
        return this.getInterfaceSubClassNat(this.iPTR, iIntIndex, iSetIndex);
    }

    public byte getInterfaceProtocol(int iIntIndex, int iSetIndex) throws USBException {
        return this.getInterfaceProtocolNat(this.iPTR, iIntIndex, iSetIndex);
    }

    public int getInterfaceStringIndex(int iIntIndex, int iSetIndex) throws USBException {
        return this.getInterfaceStringIndexNat(this.iPTR, iIntIndex, iSetIndex);
    }

    public int getInterfaceCurrentSetting(int iIntIndex) throws USBException {
        return this.getInterfaceCurrentSettingNat(this.iPTR, iIntIndex);
    }

    public boolean setInterfaceCurrentSetting(int iIntIndex, int iSetIndex) throws USBException {
        return this.setInterfaceCurrentSettingNat(this.iPTR, iIntIndex, iSetIndex);
    }

    public int getEndpointMaxPacketSize(int iIntIndex, int iSetIndex, int iEndpointIndex) throws USBException {
        return this.getEndpointMaxPacketSizeNat(this.iPTR, iIntIndex, iSetIndex, iEndpointIndex);
    }

    public byte getEndpointAddress(int iIntIndex, int iSetIndex, int iEndpointIndex) throws USBException {
        return this.getEndpointAddressNat(this.iPTR, iIntIndex, iSetIndex, iEndpointIndex);
    }

    public byte getEndpointInterval(int iIntIndex, int iSetIndex, int iEndpointIndex) throws USBException {
        return this.getEndpointIntervalNat(this.iPTR, iIntIndex, iSetIndex, iEndpointIndex);
    }

    public byte getEndpointPipeType(int iIntIndex, int iSetIndex, int iEndpointIndex) throws USBException {
        return this.getEndpointPipeTypeNat(this.iPTR, iIntIndex, iSetIndex, iEndpointIndex);
    }

    public boolean pipeReset(int iIntIndex, int iEndpointIndex) throws USBException {
        return this.resetPipeNat(this.iPTR, iIntIndex, iEndpointIndex);
    }

    public int readPipeBulkInterrupt(int iIntIndex, int iEndpointIndex, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.readPipeBulkInterruptNat(this.iPTR, iIntIndex, iEndpointIndex, baData, iArrayOffset, iNumBytes);
    }

    public int writePipeBulkInterrupt(int iIntIndex, int iEndpointIndex, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.writePipeBulkInterruptNat(this.iPTR, iIntIndex, iEndpointIndex, baData, iArrayOffset, iNumBytes);
    }

    public int readPipeIsochronous(int iIntIndex, int iEndpointIndex, long lPacketSize, long lFrameOffset, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.readPipeIsochronousNat(this.iPTR, iIntIndex, iEndpointIndex, lPacketSize, lFrameOffset, baData, iArrayOffset, iNumBytes);
    }

    public int writePipeIsochronous(int iIntIndex, int iEndpointIndex, long lPacketSize, long lFrameOffset, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.writePipeIsochronousNat(this.iPTR, iIntIndex, iEndpointIndex, lPacketSize, lFrameOffset, baData, iArrayOffset, iNumBytes);
    }

    public long getDeviceIsochronousMaxFrameOffset() throws USBException {
        return this.getDeviceIsochronousFrameOffsetNat(this.iPTR);
    }

    public int writeE0VendorControl(short sRecipient, short sRequest, short sValue, short sIndex, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.writeE0VendorControlNat(this.iPTR, sRecipient, sRequest, sValue, sIndex, baData, iArrayOffset, iNumBytes);
    }

    public int readE0VendorControl(short sRecipient, short sRequest, short sValue, short sIndex, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.readE0VendorControlNat(this.iPTR, sRecipient, sRequest, sValue, sIndex, baData, iArrayOffset, iNumBytes);
    }

    public int writeE0ClassControl(short sRecipient, short sRequest, short sValue, short sIndex, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.writeE0ClassControlNat(this.iPTR, sRecipient, sRequest, sValue, sIndex, baData, iArrayOffset, iNumBytes);
    }

    public int readE0ClassControl(short sRecipient, short sRequest, short sValue, short sIndex, byte[] baData, int iArrayOffset, int iNumBytes) throws USBException {
        if (iArrayOffset < 0 | iNumBytes + iArrayOffset > baData.length) {
            throw new USBException("Invalid Request for this buffer, check buffer length, offset and num bytes requested.");
        }
        return (int)this.readE0ClassControlNat(this.iPTR, sRecipient, sRequest, sValue, sIndex, baData, iArrayOffset, iNumBytes);
    }

    public boolean setE0FeatureControl(short sRecipient, short sFeature, short sIndex, boolean blSetClr) throws USBException {
        return this.setE0FeatureControlNat(this.iPTR, sRecipient, sFeature, sIndex, blSetClr);
    }

    public short getE0StatusControl(short sRecipient, short sIndex) throws USBException {
        return this.getE0StatusControlNat(this.iPTR, sRecipient, sIndex);
    }

    public boolean setControlTimeOut(long lTimeOut) throws USBException {
        return this.setControlTimeOutNat(this.iPTR, lTimeOut);
    }

    public boolean setReadWriteTimeOut(long lTimeOut) throws USBException {
        return this.setReadWriteTimeOutNat(this.iPTR, lTimeOut);
    }

    public long getReadWriteTimeOut() throws USBException {
        return this.getReadWriteTimeOutNat(this.iPTR);
    }

    public long getControlTimeOut() throws USBException {
        return this.getControlTimeOutNat(this.iPTR);
    }

    static {
        System.loadLibrary("IcasteCommUSBWin32_2_0");
    }
}

