/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.TrustManagerFactoryImpl;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public final class DefaultSSLContextImpl
extends SSLContextImpl {
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final Debug debug = Debug.getInstance("ssl");
    private static volatile SSLContextImpl defaultImpl;
    private static TrustManager[] defaultTrustManagers;
    private static KeyManager[] defaultKeyManagers;

    public DefaultSSLContextImpl() throws Exception {
        super(defaultImpl);
        try {
            super.engineInit(DefaultSSLContextImpl.getDefaultKeyManager(), DefaultSSLContextImpl.getDefaultTrustManager(), null);
        }
        catch (Exception exception) {
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("default context init failed: " + exception);
            }
            throw exception;
        }
        if (defaultImpl == null) {
            defaultImpl = this;
        }
    }

    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        throw new KeyManagementException("Default SSLContext is initialized automatically");
    }

    static synchronized SSLContextImpl getDefaultImpl() throws Exception {
        if (defaultImpl == null) {
            new DefaultSSLContextImpl();
        }
        return defaultImpl;
    }

    private static synchronized TrustManager[] getDefaultTrustManager() throws Exception {
        if (defaultTrustManagers != null) {
            return defaultTrustManagers;
        }
        KeyStore keyStore = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        defaultTrustManagers = trustManagerFactory.getTrustManagers();
        return defaultTrustManagers;
    }

    private static synchronized KeyManager[] getDefaultKeyManager() throws Exception {
        if (defaultKeyManagers != null) {
            return defaultKeyManagers;
        }
        final HashMap hashMap = new HashMap();
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                hashMap.put("keyStore", System.getProperty("javax.net.ssl.keyStore", ""));
                hashMap.put("keyStoreType", System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
                hashMap.put("keyStoreProvider", System.getProperty("javax.net.ssl.keyStoreProvider", ""));
                hashMap.put("keyStorePasswd", System.getProperty("javax.net.ssl.keyStorePassword", ""));
                return null;
            }
        });
        final String string = (String)hashMap.get("keyStore");
        String string2 = (String)hashMap.get("keyStoreType");
        String string3 = (String)hashMap.get("keyStoreProvider");
        if (debug != null && Debug.isOn("defaultctx")) {
            System.out.println("keyStore is : " + string);
            System.out.println("keyStore type is : " + string2);
            System.out.println("keyStore provider is : " + string3);
        }
        if (P11KEYSTORE.equals(string2) && !NONE.equals(string)) {
            throw new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE");
        }
        FileInputStream fileInputStream = null;
        if (string.length() != 0 && !NONE.equals(string)) {
            fileInputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws Exception {
                    return new FileInputStream(string);
                }
            });
        }
        String string4 = (String)hashMap.get("keyStorePasswd");
        char[] cArray = null;
        if (string4.length() != 0) {
            cArray = string4.toCharArray();
        }
        KeyStore keyStore = null;
        if (string2.length() != 0) {
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keystore");
            }
            keyStore = string3.length() == 0 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
            keyStore.load(fileInputStream, cArray);
        }
        if (fileInputStream != null) {
            fileInputStream.close();
            fileInputStream = null;
        }
        if (debug != null && Debug.isOn("defaultctx")) {
            System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        if (P11KEYSTORE.equals(string2)) {
            keyManagerFactory.init(keyStore, null);
        } else {
            keyManagerFactory.init(keyStore, cArray);
        }
        defaultKeyManagers = keyManagerFactory.getKeyManagers();
        return defaultKeyManagers;
    }
}

