/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.Trace;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DeployCookieSelector
extends java.net.CookieHandler {
    private HashMap cookieTable = new HashMap();
    private CookieHandler cookieHandler = null;

    public static synchronized void reset() {
        java.net.CookieHandler.setDefault(new DeployCookieSelector());
    }

    public synchronized Map get(URI uRI, Map map) throws IOException {
        String string = this.getCookieInfo(uRI.toURL());
        HashMap hashMap = new HashMap();
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            hashMap.put("Cookie", arrayList);
        }
        return hashMap;
    }

    public synchronized void put(URI uRI, Map map) throws IOException {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            List list;
            String string = (String)iterator.next();
            if (string == null || !string.equalsIgnoreCase("Set-Cookie") || (list = (List)map.get(string)) == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (string2 == null) continue;
                this.setCookieInfo(uRI.toURL(), string2);
            }
        }
    }

    protected void setCookieInfo(URL uRL, String string) {
        this.initializeImpl();
        Trace.msgNetPrintln("net.cookie.server", new Object[]{uRL, string});
        try {
            this.setCookieInBrowser(uRL, string);
        }
        catch (CookieUnavailableException cookieUnavailableException) {
            System.out.println(ResourceManager.getMessage("net.cookie.ignore.setcookie"));
        }
    }

    protected String getCookieInfo(URL uRL) {
        this.initializeImpl();
        String string = null;
        try {
            String string2 = uRL.getProtocol() + uRL.getHost() + uRL.getFile();
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                return null;
            }
            string2 = string2.substring(0, n);
            try {
                string = this.getCookieFromBrowser(uRL);
                if (!(string == null || string.equals("") || string.equals("\n") || string.equals("\r\n"))) {
                    this.cookieTable.put(string2, string);
                } else {
                    this.cookieTable.put(string2, "");
                    string = null;
                }
            }
            catch (CookieUnavailableException cookieUnavailableException) {
                System.out.println(ResourceManager.getMessage("net.cookie.noservice"));
                string = (String)this.cookieTable.get(string2);
            }
            if (string != null) {
                Trace.msgNetPrintln("net.cookie.connect", new Object[]{uRL, string});
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    protected void initializeImpl() {
        if (this.cookieHandler == null) {
            Service service = ServiceManager.getService();
            this.cookieHandler = service.getCookieHandler();
        }
    }

    protected void setCookieInBrowser(URL uRL, String string) throws CookieUnavailableException {
        if (this.cookieHandler != null) {
            this.cookieHandler.setCookieInfo(uRL, string);
        }
    }

    protected String getCookieFromBrowser(URL uRL) throws CookieUnavailableException {
        if (this.cookieHandler != null) {
            return this.cookieHandler.getCookieInfo(uRL);
        }
        return null;
    }
}

