/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.html.HTMLDocument;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.core.Attr;
import sun.plugin.dom.core.CDATASection;
import sun.plugin.dom.core.Comment;
import sun.plugin.dom.core.DocumentFragment;
import sun.plugin.dom.core.NamedNodeMap;
import sun.plugin.dom.core.Text;
import sun.plugin.dom.css.CSSCharsetRule;
import sun.plugin.dom.css.CSSFontFaceRule;
import sun.plugin.dom.css.CSSImportRule;
import sun.plugin.dom.css.CSSMediaRule;
import sun.plugin.dom.css.CSSPageRule;
import sun.plugin.dom.css.CSSPrimitiveValue;
import sun.plugin.dom.css.CSSRuleList;
import sun.plugin.dom.css.CSSStyleDeclaration;
import sun.plugin.dom.css.CSSStyleRule;
import sun.plugin.dom.css.CSSStyleSheet;
import sun.plugin.dom.css.CSSUnknownRule;
import sun.plugin.dom.css.CSSValue;
import sun.plugin.dom.css.CSSValueList;
import sun.plugin.dom.css.Counter;
import sun.plugin.dom.css.RGBColor;
import sun.plugin.dom.css.Rect;
import sun.plugin.dom.exception.PluginNotSupportedException;
import sun.plugin.dom.html.HTMLAnchorElement;
import sun.plugin.dom.html.HTMLAppletElement;
import sun.plugin.dom.html.HTMLAreaElement;
import sun.plugin.dom.html.HTMLBRElement;
import sun.plugin.dom.html.HTMLBaseElement;
import sun.plugin.dom.html.HTMLBodyElement;
import sun.plugin.dom.html.HTMLCollection;
import sun.plugin.dom.html.HTMLDListElement;
import sun.plugin.dom.html.HTMLDirectoryElement;
import sun.plugin.dom.html.HTMLDivElement;
import sun.plugin.dom.html.HTMLElement;
import sun.plugin.dom.html.HTMLFieldSetElement;
import sun.plugin.dom.html.HTMLFontElement;
import sun.plugin.dom.html.HTMLFormElement;
import sun.plugin.dom.html.HTMLFrameElement;
import sun.plugin.dom.html.HTMLFrameSetElement;
import sun.plugin.dom.html.HTMLHRElement;
import sun.plugin.dom.html.HTMLHeadElement;
import sun.plugin.dom.html.HTMLHeadingElement;
import sun.plugin.dom.html.HTMLHtmlElement;
import sun.plugin.dom.html.HTMLIFrameElement;
import sun.plugin.dom.html.HTMLImageElement;
import sun.plugin.dom.html.HTMLInputElement;
import sun.plugin.dom.html.HTMLIsIndexElement;
import sun.plugin.dom.html.HTMLLIElement;
import sun.plugin.dom.html.HTMLLabelElement;
import sun.plugin.dom.html.HTMLLegendElement;
import sun.plugin.dom.html.HTMLLinkElement;
import sun.plugin.dom.html.HTMLMapElement;
import sun.plugin.dom.html.HTMLMenuElement;
import sun.plugin.dom.html.HTMLMetaElement;
import sun.plugin.dom.html.HTMLModElement;
import sun.plugin.dom.html.HTMLOListElement;
import sun.plugin.dom.html.HTMLObjectElement;
import sun.plugin.dom.html.HTMLOptGroupElement;
import sun.plugin.dom.html.HTMLOptionElement;
import sun.plugin.dom.html.HTMLParagraphElement;
import sun.plugin.dom.html.HTMLParamElement;
import sun.plugin.dom.html.HTMLPreElement;
import sun.plugin.dom.html.HTMLQuoteElement;
import sun.plugin.dom.html.HTMLScriptElement;
import sun.plugin.dom.html.HTMLSelectElement;
import sun.plugin.dom.html.HTMLStyleElement;
import sun.plugin.dom.html.HTMLTableCaptionElement;
import sun.plugin.dom.html.HTMLTableCellElement;
import sun.plugin.dom.html.HTMLTableColElement;
import sun.plugin.dom.html.HTMLTableElement;
import sun.plugin.dom.html.HTMLTableRowElement;
import sun.plugin.dom.html.HTMLTableSectionElement;
import sun.plugin.dom.html.HTMLTextAreaElement;
import sun.plugin.dom.html.HTMLTitleElement;
import sun.plugin.dom.html.HTMLUListElement;
import sun.plugin.dom.stylesheets.MediaList;
import sun.plugin.dom.stylesheets.StyleSheet;
import sun.plugin.dom.stylesheets.StyleSheetList;

public class DOMObjectFactory {
    private static HashMap elmTagClassMap = null;

    public static Node createNode(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            DOMObject dOMObject = (DOMObject)object;
            int n = ((Number)dOMObject.getMember("nodeType")).intValue();
            switch (n) {
                case 1: {
                    return DOMObjectFactory.createHTMLElement(dOMObject, (HTMLDocument)document);
                }
                case 2: {
                    return DOMObjectFactory.createAttr(dOMObject, document);
                }
                case 3: {
                    return new Text(dOMObject, document);
                }
                case 4: {
                    return new CDATASection(dOMObject, document);
                }
                case 5: {
                    throw new PluginNotSupportedException("Entity reference nodes are not supported");
                }
                case 6: {
                    throw new PluginNotSupportedException("Entity nodes are not supported");
                }
                case 7: {
                    throw new PluginNotSupportedException("Processing instruction nodes are not supported");
                }
                case 8: {
                    return new Comment(dOMObject, document);
                }
                case 9: {
                    return DOMObjectFactory.createHTMLElement(dOMObject, (HTMLDocument)document);
                }
                case 10: {
                    throw new PluginNotSupportedException("Document type nodes are not supported");
                }
                case 11: {
                    return new DocumentFragment(dOMObject, document);
                }
                case 12: {
                    throw new PluginNotSupportedException("Notation nodes are not supported");
                }
            }
            throw new PluginNotSupportedException("Unknown node type " + n);
        }
        return null;
    }

    public static org.w3c.dom.html.HTMLElement createHTMLElement(Object object, HTMLDocument hTMLDocument) {
        if (object == null || !(object instanceof DOMObject)) {
            return null;
        }
        Class clazz = DOMObjectFactory.getRealClassByTagName((DOMObject)object);
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{DOMObject.class, HTMLDocument.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{object, hTMLDocument};
                return (org.w3c.dom.html.HTMLElement)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new HTMLElement((DOMObject)object, hTMLDocument);
    }

    public static org.w3c.dom.html.HTMLFormElement createHTMLFormElement(Object object, HTMLDocument hTMLDocument) {
        org.w3c.dom.html.HTMLElement hTMLElement = DOMObjectFactory.createHTMLElement(object, hTMLDocument);
        if (hTMLElement != null && hTMLElement instanceof org.w3c.dom.html.HTMLFormElement) {
            return (org.w3c.dom.html.HTMLFormElement)hTMLElement;
        }
        return null;
    }

    public static org.w3c.dom.html.HTMLOptionElement createHTMLOptionElement(Object object, HTMLDocument hTMLDocument) {
        org.w3c.dom.html.HTMLElement hTMLElement = DOMObjectFactory.createHTMLElement(object, hTMLDocument);
        if (hTMLElement != null && hTMLElement instanceof org.w3c.dom.html.HTMLOptionElement) {
            return (org.w3c.dom.html.HTMLOptionElement)hTMLElement;
        }
        return null;
    }

    public static NodeList createNodeList(Object object, HTMLDocument hTMLDocument) {
        if (object != null && object instanceof DOMObject) {
            return new HTMLCollection((DOMObject)object, hTMLDocument);
        }
        return null;
    }

    public static org.w3c.dom.NamedNodeMap createNamedNodeMap(Object object, HTMLDocument hTMLDocument) {
        if (object != null && object instanceof DOMObject) {
            return new NamedNodeMap((DOMObject)object, hTMLDocument);
        }
        return null;
    }

    public static org.w3c.dom.html.HTMLCollection createHTMLCollection(Object object, HTMLDocument hTMLDocument) {
        return (org.w3c.dom.html.HTMLCollection)((Object)DOMObjectFactory.createNodeList(object, hTMLDocument));
    }

    public static org.w3c.dom.Attr createAttr(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new Attr((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.stylesheets.StyleSheetList createStyleSheetList(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new StyleSheetList((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.stylesheets.StyleSheet createStyleSheet(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new StyleSheet((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.stylesheets.MediaList createMediaList(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new MediaList((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.css.CSSStyleSheet createCSSStyleSheet(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new CSSStyleSheet((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.css.CSSStyleDeclaration createCSSStyleDeclaration(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new CSSStyleDeclaration((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.css.CSSValue createCSSValue(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            try {
                Number number = (Number)((DOMObject)object).getMember("cssValueType");
                switch (number.intValue()) {
                    case 0: 
                    case 3: {
                        return new CSSValue((DOMObject)object, document);
                    }
                    case 1: {
                        return new CSSPrimitiveValue((DOMObject)object, document);
                    }
                    case 2: {
                        return new CSSValueList((DOMObject)object, document);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static org.w3c.dom.css.CSSPrimitiveValue createCSSPrimitiveValue(Object object, Document document) {
        org.w3c.dom.css.CSSValue cSSValue = DOMObjectFactory.createCSSValue(object, document);
        if (cSSValue != null && cSSValue instanceof org.w3c.dom.css.CSSPrimitiveValue) {
            return (org.w3c.dom.css.CSSPrimitiveValue)cSSValue;
        }
        return null;
    }

    public static CSSRule createCSSRule(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            try {
                DOMObject dOMObject = (DOMObject)object;
                int n = ((Number)dOMObject.getMember("type")).intValue();
                switch (n) {
                    case 0: {
                        return new CSSUnknownRule(dOMObject, document);
                    }
                    case 1: {
                        return new CSSStyleRule(dOMObject, document);
                    }
                    case 2: {
                        return new CSSCharsetRule(dOMObject, document);
                    }
                    case 3: {
                        return new CSSImportRule(dOMObject, document);
                    }
                    case 4: {
                        return new CSSMediaRule(dOMObject, document);
                    }
                    case 5: {
                        return new CSSFontFaceRule(dOMObject, document);
                    }
                    case 6: {
                        return new CSSPageRule(dOMObject, document);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static org.w3c.dom.css.CSSRuleList createCSSRuleList(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new CSSRuleList((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.css.Counter createCSSCounter(Object object) {
        if (object != null && object instanceof DOMObject) {
            return new Counter((DOMObject)object);
        }
        return null;
    }

    public static org.w3c.dom.css.Rect createCSSRect(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new Rect((DOMObject)object, document);
        }
        return null;
    }

    public static org.w3c.dom.css.RGBColor createCSSRGBColor(Object object, Document document) {
        if (object != null && object instanceof DOMObject) {
            return new RGBColor((DOMObject)object, document);
        }
        return null;
    }

    private static Class getRealClassByTagName(DOMObject dOMObject) {
        try {
            Object object = dOMObject.getMember("tagName");
            if (object != null) {
                return (Class)DOMObjectFactory.getElmTagClassMap().get(object);
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private static synchronized HashMap getElmTagClassMap() {
        if (elmTagClassMap == null) {
            elmTagClassMap = new HashMap();
            elmTagClassMap.put("A", HTMLAnchorElement.class);
            elmTagClassMap.put("APPLET", HTMLAppletElement.class);
            elmTagClassMap.put("AREA", HTMLAreaElement.class);
            elmTagClassMap.put("BASE", HTMLBaseElement.class);
            elmTagClassMap.put("BLOCKQUOTE", HTMLQuoteElement.class);
            elmTagClassMap.put("BODY", HTMLBodyElement.class);
            elmTagClassMap.put("BR", HTMLBRElement.class);
            elmTagClassMap.put("CAPTION", HTMLTableCaptionElement.class);
            elmTagClassMap.put("COL", HTMLTableColElement.class);
            elmTagClassMap.put("DEL", HTMLModElement.class);
            elmTagClassMap.put("DIR", HTMLDirectoryElement.class);
            elmTagClassMap.put("DIV", HTMLDivElement.class);
            elmTagClassMap.put("DL", HTMLDListElement.class);
            elmTagClassMap.put("FIELDSET", HTMLFieldSetElement.class);
            elmTagClassMap.put("FONT", HTMLFontElement.class);
            elmTagClassMap.put("FORM", HTMLFormElement.class);
            elmTagClassMap.put("FRAME", HTMLFrameElement.class);
            elmTagClassMap.put("FRAMESET", HTMLFrameSetElement.class);
            elmTagClassMap.put("HEAD", HTMLHeadElement.class);
            elmTagClassMap.put("H1", HTMLHeadingElement.class);
            elmTagClassMap.put("H2", HTMLHeadingElement.class);
            elmTagClassMap.put("H3", HTMLHeadingElement.class);
            elmTagClassMap.put("H4", HTMLHeadingElement.class);
            elmTagClassMap.put("H5", HTMLHeadingElement.class);
            elmTagClassMap.put("H6", HTMLHeadingElement.class);
            elmTagClassMap.put("HR", HTMLHRElement.class);
            elmTagClassMap.put("HTML", HTMLHtmlElement.class);
            elmTagClassMap.put("IFRAME", HTMLIFrameElement.class);
            elmTagClassMap.put("IMAGE", HTMLImageElement.class);
            elmTagClassMap.put("INPUT", HTMLInputElement.class);
            elmTagClassMap.put("INS", HTMLModElement.class);
            elmTagClassMap.put("ISINDEX", HTMLIsIndexElement.class);
            elmTagClassMap.put("LABEL", HTMLLabelElement.class);
            elmTagClassMap.put("LEGEND", HTMLLegendElement.class);
            elmTagClassMap.put("LI", HTMLLIElement.class);
            elmTagClassMap.put("LINK", HTMLLinkElement.class);
            elmTagClassMap.put("MAP", HTMLMapElement.class);
            elmTagClassMap.put("MENU", HTMLMenuElement.class);
            elmTagClassMap.put("META", HTMLMetaElement.class);
            elmTagClassMap.put("MOD", HTMLModElement.class);
            elmTagClassMap.put("OBJECT", HTMLObjectElement.class);
            elmTagClassMap.put("OL", HTMLOListElement.class);
            elmTagClassMap.put("OPTGROUP", HTMLOptGroupElement.class);
            elmTagClassMap.put("OPTION", HTMLOptionElement.class);
            elmTagClassMap.put("P", HTMLParagraphElement.class);
            elmTagClassMap.put("PARAM", HTMLParamElement.class);
            elmTagClassMap.put("PRE", HTMLPreElement.class);
            elmTagClassMap.put("Q", HTMLQuoteElement.class);
            elmTagClassMap.put("SCRIPT", HTMLScriptElement.class);
            elmTagClassMap.put("SELECT", HTMLSelectElement.class);
            elmTagClassMap.put("STYLE", HTMLStyleElement.class);
            elmTagClassMap.put("TABLE", HTMLTableElement.class);
            elmTagClassMap.put("TBODY", HTMLTableSectionElement.class);
            elmTagClassMap.put("TD", HTMLTableCellElement.class);
            elmTagClassMap.put("TFOOT", HTMLTableSectionElement.class);
            elmTagClassMap.put("TH", HTMLTableCellElement.class);
            elmTagClassMap.put("THEAD", HTMLTableSectionElement.class);
            elmTagClassMap.put("TR", HTMLTableRowElement.class);
            elmTagClassMap.put("TEXTARRA", HTMLTextAreaElement.class);
            elmTagClassMap.put("TITLE", HTMLTitleElement.class);
            elmTagClassMap.put("UL", HTMLUListElement.class);
            elmTagClassMap.put("ACRONYM", HTMLElement.class);
            elmTagClassMap.put("ABBR", HTMLElement.class);
            elmTagClassMap.put("ADDRESS", HTMLElement.class);
            elmTagClassMap.put("B", HTMLElement.class);
            elmTagClassMap.put("BDO", HTMLElement.class);
            elmTagClassMap.put("BIG", HTMLElement.class);
            elmTagClassMap.put("CITE", HTMLElement.class);
            elmTagClassMap.put("CENTER", HTMLElement.class);
            elmTagClassMap.put("CODE", HTMLElement.class);
            elmTagClassMap.put("DD", HTMLElement.class);
            elmTagClassMap.put("DFN", HTMLElement.class);
            elmTagClassMap.put("DT", HTMLElement.class);
            elmTagClassMap.put("EM", HTMLElement.class);
            elmTagClassMap.put("I", HTMLElement.class);
            elmTagClassMap.put("KBD", HTMLElement.class);
            elmTagClassMap.put("NOFRAMES", HTMLElement.class);
            elmTagClassMap.put("NOSCRIPT", HTMLElement.class);
            elmTagClassMap.put("S", HTMLElement.class);
            elmTagClassMap.put("SAMP", HTMLElement.class);
            elmTagClassMap.put("SMALL", HTMLElement.class);
            elmTagClassMap.put("SPAN", HTMLElement.class);
            elmTagClassMap.put("STRIKE", HTMLElement.class);
            elmTagClassMap.put("STRONG", HTMLElement.class);
            elmTagClassMap.put("SUB", HTMLElement.class);
            elmTagClassMap.put("SUP", HTMLElement.class);
            elmTagClassMap.put("U", HTMLElement.class);
            elmTagClassMap.put("VAR", HTMLElement.class);
        }
        return elmTagClassMap;
    }
}

