/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ClipboardServiceImpl;
import com.sun.jnlp.DownloadServiceImpl;
import com.sun.jnlp.ExtendedServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.FileSaveServiceImpl;
import com.sun.jnlp.JNLPClassLoaderIf;
import com.sun.jnlp.PersistenceServiceImpl;
import com.sun.jnlp.PrintServiceImpl;
import com.sun.jnlp.SingleInstanceServiceImpl;
import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.jar.JarFile;
import javax.jnlp.BasicService;
import javax.jnlp.ClipboardService;
import javax.jnlp.DownloadService;
import javax.jnlp.ExtendedService;
import javax.jnlp.ExtensionInstallerService;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.PrintService;
import javax.jnlp.SingleInstanceService;
import sun.awt.AppContext;

public final class JNLPClassLoader
extends URLClassLoader
implements JNLPClassLoaderIf {
    private static JNLPClassLoader _instance = null;
    private LaunchDesc _launchDesc = null;
    private AppPolicy _appPolicy;
    private AccessControlContext _acc = null;
    private boolean _initialized = false;
    private ArrayList _jarsInURLClassLoader = new ArrayList();
    private ArrayList _jarsNotInURLClassLoader = new ArrayList();

    private JNLPClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
    }

    private void initialize(LaunchDesc launchDesc, AppPolicy appPolicy) {
        this._launchDesc = launchDesc;
        this._acc = AccessController.getContext();
        this._appPolicy = appPolicy;
        this._initialized = true;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            this.sortDescriptors(resourcesDesc);
            for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
                JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
                this.addURL(jARDesc.getLocation());
            }
        }
    }

    public static JNLPClassLoader createClassLoader() {
        if (_instance == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            _instance = classLoader instanceof JNLPClassLoader ? (JNLPClassLoader)classLoader : new JNLPClassLoader(classLoader);
        }
        return _instance;
    }

    public static JNLPClassLoader createClassLoader(LaunchDesc launchDesc, AppPolicy appPolicy) {
        JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader();
        if (!jNLPClassLoader._initialized) {
            jNLPClassLoader.initialize(launchDesc, appPolicy);
        }
        return jNLPClassLoader;
    }

    public static JNLPClassLoaderIf getInstance() {
        return _instance;
    }

    public LaunchDesc getLaunchDesc() {
        return this._launchDesc;
    }

    public void downloadResource(URL uRL, String string, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadResource(this._launchDesc, uRL, string, downloadProgress, bl);
    }

    public void downloadParts(String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadParts(this._launchDesc, stringArray, downloadProgress, bl);
    }

    public void downloadExtensionParts(URL uRL, String string, String[] stringArray, LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadExtensionPart(this._launchDesc, uRL, string, stringArray, downloadProgress, bl);
    }

    public void downloadEager(LaunchDownload.DownloadProgress downloadProgress, boolean bl) throws JNLPException, IOException {
        LaunchDownload.downloadEagerorAll(this._launchDesc, false, downloadProgress, bl);
    }

    public JARDesc getJarDescFromURL(URL uRL) {
        for (int i = 0; i < this._jarsInURLClassLoader.size(); ++i) {
            JARDesc jARDesc = (JARDesc)this._jarsInURLClassLoader.get(i);
            if (!jARDesc.getLocation().toString().equals(uRL.toString())) continue;
            return jARDesc;
        }
        return null;
    }

    public int getDefaultSecurityModel() {
        return this._launchDesc.getSecurityModel();
    }

    public URL getResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() throws SecurityException {
                URL uRL = null;
                for (int i = 0; uRL == null && i < 3; ++i) {
                    uRL = JNLPClassLoader.super.getResource(string);
                }
                return uRL;
            }
        });
        return uRL;
    }

    protected String findLibrary(String string) {
        if (!this._initialized) {
            return super.findLibrary(string);
        }
        string = Config.getInstance().getLibraryPrefix() + string + Config.getInstance().getLibrarySufix();
        Trace.println((String)("Looking up native library: " + string), (TraceLevel)TraceLevel.NETWORK);
        File[] fileArray = LaunchDownload.getNativeDirectories(this._launchDesc);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = new File(fileArray[i], string);
            Trace.println((String)("Looking up native library in: " + file), (TraceLevel)TraceLevel.BASIC);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        Trace.println((String)("Native library " + string + " not found"), (TraceLevel)TraceLevel.NETWORK);
        return super.findLibrary(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        if (!this._initialized) {
            return super.findClass(string);
        }
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.checkPackageParts(string)) {
                return super.findClass(string);
            }
            throw classNotFoundException;
        }
    }

    public URL findResource(String string) {
        URL uRL = super.findResource(string);
        if (!this._initialized) {
            return uRL;
        }
        if (uRL == null && this.checkPackageParts(string)) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    private boolean checkPackageParts(String string) {
        boolean bl = false;
        ResourcesDesc.PackageInformation packageInformation = this._launchDesc.getResources().getPackageInformation(string);
        if (packageInformation != null) {
            JARDesc[] jARDescArray = packageInformation.getLaunchDesc().getResources().getPart(packageInformation.getPart());
            for (int i = 0; i < jARDescArray.length; ++i) {
                if (!this._jarsNotInURLClassLoader.contains(jARDescArray[i])) continue;
                this._jarsNotInURLClassLoader.remove(jARDescArray[i]);
                this._jarsInURLClassLoader.add(jARDescArray[i]);
                this.addURL(jARDescArray[i].getLocation());
                bl = true;
            }
        }
        return bl;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        try {
            this._appPolicy.addPermissions(JNLPClassLoader.getInstance(), permissionCollection, codeSource, true);
        }
        catch (ExitException exitException) {
            Trace.println((String)("_appPolicy.addPermissions: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
        URL uRL = codeSource.getLocation();
        JARDesc jARDesc = this.getJarDescFromURL(uRL);
        if (jARDesc != null) {
            try {
                File file = DownloadEngine.getCachedFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                if (file != null) {
                    String string = file.getPath();
                    permissionCollection.add(new FilePermission(string, "read"));
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        if (!permissionCollection.implies(new AWTPermission("accessClipboard"))) {
            AppContext.getAppContext().put("UNTRUSTED_URLClassLoader", Boolean.TRUE);
        }
        return permissionCollection;
    }

    public JarFile getJarFile(URL uRL) throws IOException {
        final JARDesc jARDesc = this.getJarDescFromURL(uRL);
        JarFile jarFile = null;
        if (jARDesc != null) {
            jarFile = (JarFile)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() throws SecurityException {
                    try {
                        JarFile jarFile = DownloadEngine.getCachedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                        if (jarFile != null) {
                            return jarFile;
                        }
                        return DownloadEngine.getUpdatedJarFile((URL)jARDesc.getLocation(), (String)jARDesc.getVersion());
                    }
                    catch (IOException iOException) {
                        Trace.ignoredException((Exception)iOException);
                        return null;
                    }
                }
            });
            if (jarFile == null) {
                throw new IOException("Resource not found: " + jARDesc.getLocation() + ":" + jARDesc.getVersion());
            }
            return jarFile;
        }
        return null;
    }

    private void sortDescriptors(ResourcesDesc resourcesDesc) {
        int n;
        ArrayList<JARDesc> arrayList = new ArrayList<JARDesc>();
        JARDesc[] jARDescArray = resourcesDesc.getEagerOrAllJarDescs(true);
        JARDesc jARDesc = resourcesDesc.getMainJar(true);
        if (jARDesc != null) {
            this._jarsInURLClassLoader.add(jARDesc);
        }
        for (n = 0; n < jARDescArray.length; ++n) {
            if (jARDescArray[n] == jARDesc) continue;
            if (!jARDescArray[n].isLazyDownload()) {
                this._jarsInURLClassLoader.add(jARDescArray[n]);
                continue;
            }
            if (!resourcesDesc.isPackagePart(jARDescArray[n].getPartName())) {
                arrayList.add(jARDescArray[n]);
                continue;
            }
            this._jarsNotInURLClassLoader.add(jARDescArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this._jarsInURLClassLoader.add(arrayList.get(n));
        }
    }

    public void addResource(URL uRL, String string, String string2) {
        JARDesc jARDesc = new JARDesc(uRL, string, true, false, false, null, 0, null);
        if (!this._jarsInURLClassLoader.contains(jARDesc)) {
            this._launchDesc.getResources().addResource(jARDesc);
            this._jarsInURLClassLoader.add(jARDesc);
            this.addURL(uRL);
        }
    }

    public BasicService getBasicService() {
        return BasicServiceImpl.getInstance();
    }

    public FileOpenService getFileOpenService() {
        return FileOpenServiceImpl.getInstance();
    }

    public FileSaveService getFileSaveService() {
        return FileSaveServiceImpl.getInstance();
    }

    public ExtensionInstallerService getExtensionInstallerService() {
        return ExtensionInstallerServiceImpl.getInstance();
    }

    public DownloadService getDownloadService() {
        return DownloadServiceImpl.getInstance();
    }

    public ClipboardService getClipboardService() {
        return ClipboardServiceImpl.getInstance();
    }

    public PrintService getPrintService() {
        return PrintServiceImpl.getInstance();
    }

    public PersistenceService getPersistenceService() {
        return PersistenceServiceImpl.getInstance();
    }

    public ExtendedService getExtendedService() {
        return ExtendedServiceImpl.getInstance();
    }

    public SingleInstanceService getSingleInstanceService() {
        return SingleInstanceServiceImpl.getInstance();
    }
}

