import java.awt.*;
import java.awt.event.*;
import com.icaste.JCommUSB_2_0.*;

public class usb2820 {

    static USBDevice myUSB;

    /** Creates a new instance of USB2820 */
    public usb2820(global g, disp d, Graphics gg) {
        int i = 0;
        String szPath = "";
        if (g.get_vsrt() != 0 && g.get_radiosim() == 0) {
            if (g.get_debug() == 1)
                System.out.println("Start USB2820");
            try {
                i = USBDevice.getNumAttachedDevices();
                szPath = USBDevice.getAttachedDevicePath(0);
                if (g.get_debug() == 1)
                    System.out.println("Device Path of Device at index 0 = " + szPath);
                myUSB = new USBDevice(szPath);

                //get DevData 
                if (g.get_debug() == 1) {
                    System.out.println("\n\nDevice Desc Data\n");
                    System.out.println("Device Class " + myUSB.getDeviceClass());
                    System.out.println("Device Sub Class " + myUSB.getDeviceSubClass());
                    System.out.println("Device E0 max packet size " + myUSB.getDeviceE0MaxPacketSize());
                    System.out.println("Device Manufacturer String index " +
                                       myUSB.getDeviceManufacturerStringIndex());
                    if (myUSB.getDeviceManufacturerStringIndex() > 0) {
                        System.out.println(myUSB.
                                           queryString(myUSB.getDeviceManufacturerStringIndex(),
                                                       (short) 1033));
                    }
                    System.out.println("Device Num Configs " + myUSB.getDeviceNumConfigs());
                    System.out.println("Device Vendor ID " + myUSB.getDeviceVendorID());
                    System.out.println("Device Product ID " + myUSB.getDeviceProductID());
                    System.out.println("Device Product String Index " + myUSB.getDeviceProductStringIndex());
                    if (myUSB.getDeviceProductStringIndex() > 0) {
                        System.out.println(myUSB.
                                           queryString(myUSB.getDeviceProductStringIndex(), (short) 1033));
                    }
                    System.out.println("Device Protocol " + myUSB.getDeviceProtocol());
                    System.out.println("Device Version " + myUSB.getDeviceVersion());
                    System.out.println("Device Serial Number String Index " +
                                       myUSB.getDeviceSerialStringIndex());
                    if (myUSB.getDeviceSerialStringIndex() > 0) {
                        System.out.println(myUSB.
                                           queryString(myUSB.getDeviceSerialStringIndex(), (short) 1033));
                    }

                    System.out.println("\n\nConfig Desc Data\n");
                    System.out.println("Conf Current Index " + myUSB.getConfigCurrentIndex());
                    System.out.println("Conf Max Power " + myUSB.getConfigMaxPower());
                    System.out.println("Conf Num Interfaces " + myUSB.getConfigNumInterfaces());
                    System.out.println("Conf String Desc Index " + myUSB.getConfigStringDescIndex());
                    if (myUSB.getConfigStringDescIndex() > 0) {
                        System.out.println(myUSB.queryString(myUSB.getConfigStringDescIndex(), (short) 1033));
                    }

                    int numInterfaces = myUSB.getConfigNumInterfaces();
                    i = 0;

//            while(i < numInterfaces) 
                    while (i < 1) {
                        System.out.println("\n\nInterface Index " + i + " Current Setting " +
                                           myUSB.getInterfaceCurrentSetting(i));
                        int iNumSettings = myUSB.getInterfaceNumAlternateSettings(i);
                        int p = 0;
//                while(p < iNumSettings) 
                        while (p < 1) {
                            System.out.println("Interface Data for Interface index " + i +
                                               ", Setting Index " + p);
                            System.out.println("Interface Class " + myUSB.getInterfaceClass(i, p));
                            System.out.println("Interface SubClass " + myUSB.getInterfaceSubClass(i, p));
                            System.out.println("Interface Num Alternate Settings " +
                                               myUSB.getInterfaceNumAlternateSettings(i));

                            System.out.println("Interface Num Endpoints " +
                                               myUSB.getInterfaceNumEndpoints(i, p));
                            System.out.println("Interface Protocol " + myUSB.getInterfaceProtocol(i, p));
                            System.out.println("Interface String Index " +
                                               myUSB.getInterfaceStringIndex(i, p));
                            if (myUSB.getInterfaceStringIndex(i, 0) > 0) {
                                System.out.println(myUSB.
                                                   queryString(myUSB.getInterfaceStringIndex(i, p),
                                                               (short) 1033));
                            }
                            int iEndpoints = myUSB.getInterfaceNumEndpoints(i, p);
                            int q = 0;
                            System.out.println("");
                            while (q < iEndpoints) {
                                System.out.println("Endpoint Info for Interface Index " + i +
                                                   ", Setting Index " + p + ", Endpoint Index " + q);
                                System.out.println("Endpoint Address " + myUSB.getEndpointAddress(i, p, q));
                                System.out.println("Endpoint Interval " + myUSB.getEndpointInterval(i, p, q));
                                System.out.println("Endpoint MaxPacket Size " +
                                                   myUSB.getEndpointMaxPacketSize(i, p, q));
                                System.out.println("Endpoint Pipe Type: " +
                                                   myUSB.getEndpointPipeType(i, p, q));
                                switch (myUSB.getEndpointPipeType(i, p, q)) {
                                case USBDevice.PIPE_BULK:
                                    System.out.println("BULK PIPE");
                                    break;
                                case USBDevice.PIPE_INVALID:
                                    System.out.println("INVALID PIPE");
                                    break;
                                case USBDevice.PIPE_INTERRUPT:
                                    System.out.println("INTERRUPT PIPE");
                                    break;
                                case USBDevice.PIPE_ISOCHRONOUS:
                                    System.out.println("ISOCHRONOUS PIPE");
                                    break;
                                case USBDevice.PIPE_CONTROL:
                                    System.out.println("CONTROL PIPE");
                                    break;
                                }
                                System.out.println("");
                                q++;
                            }
                            p++;
                        }
                        i++;
                    }
                    System.out.println("\n\nOther Data\n");
                    short[] myLangs = myUSB.getSupportedLangIDs();
                    i = 0;
                    System.out.println("Supported Languages");
                    while (i < myLangs.length) {
                        System.out.println("LangID " + i + " " + myLangs[i]);
                        i++;
                    }

                    System.out.println("ReadWrite Time Out " + myUSB.getReadWriteTimeOut());

                    System.out.println("Control Time Out " + myUSB.getControlTimeOut());

                    System.out.println("Max Iso Frame Range = " + myUSB.getDeviceIsochronousMaxFrameOffset());
                    System.out.println("\nEND!\n");
                }

            }
            catch(Exception e) {
                System.out.println("Exception!! " + e.getMessage());
            }
            if (g.get_debug() == 1)
                System.out.println("Chip_id " + em_read(0x0a));
            set_2820(g);
            if (g.get_debug() == 1) {
                read_7113reg(0x0f);
                read_7113reg(0x11);
                vspectra(g, d, gg);
            }
        }
    }
    int em_write(int reg, int val) {
        int i = 0;
        byte data[] = new byte[1];
        data[0] = (byte) val;
        try {
            i = myUSB.writeE0VendorControl((short) 0, (short) 0, (short) 0, (short) reg, data, 0, 1);
        }
        catch(Exception e) {
            System.out.println("em_write " + e.getMessage());
        }
        return i;
    }
    int em_write2(int reg, int val0, int val1) {
        int i = 0;
        byte data[] = new byte[2];
        data[0] = (byte) val0;
        data[1] = (byte) val1;
        try {
            i = myUSB.writeE0VendorControl((short) 0, (short) 2, (short) 0, (short) reg, data, 0, 2);
        }
        catch(Exception e) {
            System.out.println("em_write2 " + e.getMessage());
        }
        return i;
    }

    int em_write3(int reg, int val) {
        int i = 0;
        byte data[] = new byte[1];
        data[0] = (byte) val;
        try {
            i = myUSB.writeE0VendorControl((short) 0, (short) 3, (short) 0, (short) reg, data, 0, 1);
        }
        catch(Exception e) {
            System.out.println("em_write3 " + e.getMessage());
        }
        return i;
    }

    int em_read(int reg) {
        int i;
        byte data[] = new byte[1];
        try {
            myUSB.setInterfaceCurrentSetting(0, 0);
/* 
     System.out.println("conf "+myUSB.getConfigCurrentIndex()); 
     System.out.println("intf "+myUSB.getInterfaceCurrentSetting(0)); 
     System.out.println("pipet "+myUSB.getEndpointPipeType(0,0,0)); 
     System.out.println("addr  "+myUSB.getEndpointAddress(0,0,0)); 
     System.out.println("prod_id "+myUSB.getDeviceProductID()); 
     if(myUSB.deviceIsConnected()) System.out.println("connected"); 
     System.out.println("E0max "+myUSB.getDeviceE0MaxPacketSize()); 
     System.out.println("timo "+myUSB.getReadWriteTimeOut()); 
*/
//     i=myUSB.readPipeBulkInterrupt(0,2,data2,0,512); 
            i = myUSB.readE0VendorControl((short) 0, (short) 0, (short) 0, (short) reg, data, 0, 1);
//     System.out.println("i "+i+" data "+data[0]); 
        }
        catch(Exception e) {
            System.out.println("em_read " + e.getMessage());
        }
//     System.out.println("reg "+reg+" data "+data[0]); 
        return data[0] & 0xff;
    }

    int em_read2(int reg) {
        int i = 0;
        byte data[] = new byte[1];
        data[0] = (byte) 0;
        try {
            i = myUSB.readE0VendorControl((short) 0, (short) 2, (short) 0, (short) reg, data, 0, 1);
        }
        catch(Exception e) {
            System.out.println("em_read2 " + e.getMessage());
        }
        return data[0] & 0xff;
    }

    int em_bulk(byte data[], int n) {
        int i = 0;
        try {
            i = myUSB.readPipeBulkInterrupt(0, 2, data, 0, n);
        }
        catch(Exception e) {
            System.out.println("em_bulk " + e.getMessage());
        }
        return i;
    }


    int em_isoc(byte data[], int n, int k) {
        int i = 0;
        long j = 0;
        try {
            myUSB.setInterfaceCurrentSetting(0, 1);
        }
        catch(Exception e) {
            System.out.println("em_altset " + e.getMessage());
        }
        try {
            i = myUSB.getEndpointMaxPacketSize(0, 1, 1);
        }
        catch(Exception e) {
            System.out.println("em_altset " + e.getMessage());
        }
//      System.out.println("MaxIsocPkt "+i); 
        try {
            i = myUSB.getInterfaceCurrentSetting(0);
        }
        catch(Exception e) {
            System.out.println("em_altset " + e.getMessage());
        }
//      System.out.println("altsetting "+i); 
        try {
            j = myUSB.getDeviceIsochronousMaxFrameOffset();
        }
        catch(Exception e) {
            System.out.println("em_altset " + e.getMessage());
        }
//      System.out.println("MaxFrameOffset "+j); 
//      System.out.println("offset "+k); 
        try {
            i = myUSB.readPipeIsochronous(0, 1, (long) 1024, (long) k, data, 0, n);
        }
        catch(Exception e) {
            System.out.println("em_isoc " + e.getMessage());
        }
        return i;
    }

    int read_7113reg(int reg) {
        int ret, ret2;
        em_write3(0x4a, reg);
        ret = em_read(0x05);
        if (ret != 0)
            System.out.println("0x05 return " + ret);
        ret2 = em_read2(0x4a);
        ret = em_read(0x05);
        if (ret != 0)
            System.out.println("return from 7113 reg " + reg + " " + ret2);
        return 0;
    }

    void em_capture(int start) {
        int ret, val;
        ret = em_read(0x0c);    // USBSUSP_REG 
        if (start != 0)
            val = ((ret & ~0x10) | (0x10 & 0x10));
        else
            val = ((ret & ~0x10) | (0x00 & 0x10));
        em_write(0x0c, val);
        if (start != 0)
            em_write(0x12, 0x67); // VINENABLE_REG starts 
        else
            em_write(0x12, 0x27); // stops 
//     System.out.println("capture "+em_read(0x12)+" "+em_read(0x0c)); 
    }

    void set_2820(global g) {
        int i;
        int val;
/* em28xx registers */
        int CHIPID_REG = 0x0a;
        int USBSUSP_REG = 0x0c; /* */

        int AUDIOSRC_REG = 0x0e;
        int XCLK_REG = 0x0f;

        int VINMODE_REG = 0x10;
        int VINCTRL_REG = 0x11;
        int VINENABLE_REG = 0x12; /* */

        int GAMMA_REG = 0x14;
        int RGAIN_REG = 0x15;
        int GGAIN_REG = 0x16;
        int BGAIN_REG = 0x17;
        int ROFFSET_REG = 0x18;
        int GOFFSET_REG = 0x19;
        int BOFFSET_REG = 0x1a;

        int OFLOW_REG = 0x1b;
        int HSTART_REG = 0x1c;
        int VSTART_REG = 0x1d;
        int CWIDTH_REG = 0x1e;
        int CHEIGHT_REG = 0x1f;

        int YGAIN_REG = 0x20;
        int YOFFSET_REG = 0x21;
        int UVGAIN_REG = 0x22;
        int UOFFSET_REG = 0x23;
        int VOFFSET_REG = 0x24;
        int SHARPNESS_REG = 0x25;

        int COMPR_REG = 0x26;
        int OUTFMT_REG = 0x27;

        int XMIN_REG = 0x28;
        int XMAX_REG = 0x29;
        int YMIN_REG = 0x2a;
        int YMAX_REG = 0x2b;

        int HSCALELOW_REG = 0x30;
        int HSCALEHIGH_REG = 0x31;
        int VSCALELOW_REG = 0x32;
        int VSCALEHIGH_REG = 0x33;

        int AC97LSB_REG = 0x40;
        int AC97MSB_REG = 0x41;
        int AC97ADDR_REG = 0x42;
        int AC97BUSY_REG = 0x43;

/* em202 registers */
        int MASTER_AC97 = 0x02;
        int VIDEO_AC97 = 0x14;


        em_write(YGAIN_REG, 0x10);
        em_write(YOFFSET_REG, 0x00); // adds to output i.e. 0x10 to 0x20 
        em_write(UVGAIN_REG, 0x10); // no obvious effect 
        em_write(UOFFSET_REG, 0x00);
        em_write(VOFFSET_REG, 0x00);
        em_write(SHARPNESS_REG, 0x00); // no obvious effect 
        em_write(GAMMA_REG, 0x20); // no obvious effect 
        em_write(RGAIN_REG, 0x20);
        em_write(GGAIN_REG, 0x20);
        em_write(BGAIN_REG, 0x20);
        em_write(ROFFSET_REG, 0x00);
        em_write(GOFFSET_REG, 0x00);
        em_write(BOFFSET_REG, 0x00);
        em_write(HSTART_REG, 0x00); // no effect 
        em_write(VSTART_REG, 0x00);
        em_write(CWIDTH_REG, 0xb4);
        if (g.get_vmode() == 0)
            em_write(CHEIGHT_REG, 0x02); // sets number lines returned 
         else
            em_write(CHEIGHT_REG, 0x04*8);
        em_write(OFLOW_REG, 0x00);
        em_write(XMIN_REG, 0x00);
        em_write(XMAX_REG, 0xff);
        em_write(YMIN_REG, 0x00);
        em_write(YMAX_REG, 0xff);

        em_write(HSCALELOW_REG, 0x00); // 0x00  0.05 
        em_write(HSCALEHIGH_REG, 0x10);
        em_write(VSCALELOW_REG, 0x00);
        em_write(VSCALEHIGH_REG, 0x00);


//  em_write(OUTFMT_REG,0x14);            // 0001 0100   looks same as 0x34 
//  em_write(OUTFMT_REG,0x24);            // 0010 0100    high gain? 
        em_write(OUTFMT_REG, 0x30); // 0011 0100    
        em_write(VINMODE_REG, 0x10); // same as 0x10? 
//  em_write(VINMODE_REG,0x10);  
        em_write(VINCTRL_REG, 0x11); // 0x10 same 0x01 only 512 bytes 
        em_write(COMPR_REG, 0x10); // effects output rate x00 x4 
//  em_write(COMPR_REG,0x30);             // effects output rate x00 x4 

// turn GAFIX = 1, gains to 0xff  and VIPB = 1? and HPLL=1 - fixed freq AUFD=0 FSEL=1  
// ACGC = 1 - chromo gain min  - elliminates reading random chromo gain 
// HLNRS = 1 - no clamping 
// LUM changed from 01 to 80  BRIG from 80 to a0 (helps get away from 10 clamp) 

        int saa7113_adc[] = {
            0x01, 0x08, 0x02, 0xc8, 0x03, 0x77, 0x04, 0xff, 0x05, 0xff, 0x06, 0xe9, 0x07, 0x0d,
            0x08, 0x5c, 0x09, 0x80, 0x0a, 0x80, 0x0b, 0x47, 0x0c, 0x40, 0x0d, 0x00, 0x0e, 0x01, 0x0f, 0x80,
            0x10, 0x00, 0x11, 0x0c, 0x12, 0x01, 0x13, 0x00, 0x14, 0x00, 0x15, 0x00, 0x16, 0x00, 0x17, 0x00,
            0x18, 0x00, 0x19, 0x00, 0x1a, 0x00, 0x1b, 0x00, 0x1c, 0x00, 0x1d, 0x00, 0x1e, 0x00,
            0x20, 0x00, 0x21, 0x00, 0x22, 0x00, 0x23, 0x00, 0x24, 0x00, 0x25, 0x00, 0x26, 0x00, 0x27, 0x00,
            0x28, 0x00, 0x29, 0x00, 0x2a, 0x00, 0x2b, 0x00, 0x2c, 0x00, 0x2d, 0x00, 0x2e, 0x00, 0x2f, 0x00,
            0x30, 0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x37, 0x00,
            0x38, 0x00, 0x39, 0x00, 0x3a, 0x00, 0x3b, 0x00, 0x3c, 0x00, 0x3d, 0x00, 0x3e, 0x00, 0x3f, 0x00,
            0x40, 0x02, 0x41, 0xff, 0x42, 0xff, 0x43, 0xff, 0x44, 0xff, 0x45, 0xff, 0x46, 0xff, 0x47, 0xff,
            0x48, 0xff, 0x49, 0xff, 0x4a, 0xff, 0x4b, 0xff, 0x4c, 0xff, 0x4d, 0xff, 0x4e, 0xff, 0x4f, 0xff,
            0x50, 0xff, 0x51, 0xff, 0x52, 0xff, 0x53, 0xff, 0x54, 0xff, 0x55, 0xff, 0x56, 0xff, 0x57, 0xff,
            0x58, 0x00, 0x59, 0x54, 0x5a, 0x07, 0x5b, 0x83, 0x5c, 0x00, 0x5d, 0x00, 0x5e, 0x00, 0x5f, 0x00
        };
//  for(i=0;i<10;i++) System.out.println(" i "+i+"saa "+saa7113_adc[i]); 
// write out array 
        for (i = 0; i < 188; i += 2) {
            em_write2(0x4a, saa7113_adc[i], saa7113_adc[i + 1]);
            val = em_read(0x05);
            if (val > 0)
                System.out.println("0x05 return " + val);
        }
// read back array 
        for (i = 0; i < 188; i += 2) {
            em_write3(0x4a, saa7113_adc[i]);
            val = em_read(0x05);
            if (val > 0)
                System.out.println("0x05 return " + val);
            val = em_read2(0x4a);
            if (val != saa7113_adc[i + 1])
                System.out.println(" i " + i + " err " + val + " expect " + saa7113_adc[i + 1]);
            val = em_read(0x05);
            if (val != 0)
                System.out.println("0x05 return " + val);
        }
    }


void vspectra(global g, disp d, Graphics gg)
{
    byte buffer1[] = new byte[46088];
    int iord[] = new int[6];
    int jtst[] = new int[16384];
    int jimax[] = new int[6];
    int nstart[] = new int[6];
    int nstop[] = new int[6];
    double re[] = new double[16384];
    double am[] = new double[16384];
    double rre[] = new double[8192];
    double aam[] = new double[8192];
    double spec[] = new double[8192];
    double avspec[] = new double[8192];
    double wavfrm[] = new double[16384];
    double phas[] = new double[6];
    double amp[] = new double[6];
    double avamp[] = new double[6];
    double ylim = 415.0;
    double close, fclose, fmax, pmax, avsig, peakfreq, peakamp;
    double msum, mdiff, msumsq, mdiffsq;
    double power, tsig, a, b, pav, re3sum, im3sum, re3dif, im3dif, sina, cosa;
    int i, j, m, n, k, imax, blsiz, blsiz2, sync, nbyt, nbas, num, nav, nvv, istart, istop;
    int kk, nvs, nvd, nn, vmode, ifft, kn, nn2, ij, vsc, nnbyt;

    nbas = g.get_nbas();
    vmode = g.get_vmode();
    if (vmode > 0) 
        vsc = vmode;
    else 
        vsc = 1;
    blsiz = 4096 * vsc;
    nn = 2880 * vsc;
    nnbyt = 46088;
    blsiz2 = blsiz / 2;
    nn2 = nn / 2;
    for (i = 0; i < nbas; i++) {
        nstart[i] = (int) (g.get_vfstart(i) * blsiz / 3375.0);
        nstop[i] = (int) (g.get_vfstop(i) * blsiz / 3375.0);
        if (nstop[i] > blsiz2)
            nstop[i] = blsiz2;
        if (nstart[i] > blsiz2)
            nstart[i] = blsiz2;
        if (nstop[i] < 0)
            nstop[i] = 0;
        if (nstart[i] < 0)
            nstart[i] = 0;
    }
    if (nbas == 3) {
        istart = (int) (10.0 * blsiz / 3375.0);
        istop = blsiz2;
    } else {
        istart = nstart[0];
        istop = nstop[0];
    }
    g.set_vclos(999.0, 0);
    num = g.get_vnum();
    g.set_vnumm(num);
    nvv = nvs = nvd = ifft = 0;
    msum = msumsq = mdiff = mdiffsq = 0;
    avsig = 0;
    for (i = 0; i < nbas; i++) {
        g.set_vamp(0, i);
        avamp[i] = 0;
    }
    for (i = 0; i < blsiz2; i++)
        avspec[i] = 0.0;
    re3sum = im3sum = re3dif = im3dif = 0;
    for (k = 0; k < num; k++) { // needs d1.num 
        if (g.get_radiosim() == 0)
            em_capture(1);      // keep capture going to get more than 512 x 3 + 56 bytes 

        if (vmode == 0) {
            try {
                Thread.sleep(g.get_vwait()); // needs at least 40 ms for laptop 
            }
            catch(InterruptedException e) {
                System.out.println("sleepexception " + e);
            }
        }
        if (g.get_radiosim() == 0) {
            if (vmode == 0) {
                em_capture(0);  // will only get 2900 bytes before internal buffer empty? 
                nnbyt = 2888;
                nbyt = em_bulk(buffer1, nnbyt);
            }
            else {
                nnbyt = 46088;
                nbyt = em_bulk(buffer1, nnbyt);
                em_capture(0);
            }
//  for(i=0;i<100;i++) printf("i %d data %x\n",i,pbuffer1[i]); 
        } else {
            tsig = 0;
            power = 200.0 + g.get_tspill();
            if (g.get_sourn() > 0) {
                if (g.get_sounam(g.get_sourn()).lastIndexOf("Moon") > -1)
                    tsig = 1.0;
                if (g.get_sounam(g.get_sourn()).lastIndexOf("Cass") > -1)
                    tsig = 2.6;
                if (g.get_sounam(g.get_sourn()).lastIndexOf("Sun") > -1)
                    tsig = 1000.0;
            }
            if (g.get_scan() != 0 || g.get_track() != 0) {
                if (g.get_scan() > 0) {
                    a = g.get_azscanoff(g.get_scan() - 1) / g.get_beamw();
                    b = g.get_elscanoff(g.get_scan() - 1) / g.get_beamw();
                    a = (a * a + b * b) * 4.0 * 0.7;
                } else {
                    a = g.get_azoff() * Math.cos(g.get_elcmd() * Math.PI / 180.0);
                    a = (g.get_eloff() * g.get_eloff() + a * a) * 4.0 * 0.7;
                    a = a / (g.get_beamw() * g.get_beamw());
                }
                power += tsig * Math.pow(2.718, -a);
            }
            if (g.get_calon() == 1)
                power = power + g.get_tload() - g.get_tspill();
            if (g.get_calon() == 2)
                power = power + g.get_noisecal();
            d.dtext(16.0, 80.0, gg, Color.black, "generating random data");
            power *= 0.01;
            a = (g.get_vfstart(0) + g.get_vfstop(0)) * 0.5 * Math.PI / 3375.0;
            m = 0;
            for (i = 0; i < 2900; i++) {
                buffer1[i] = (byte) (power * Math.sin(m * a) + power);
                m++;
                if ((i % 360) == 1 && i > 1)
                    m += 34 * 2;
            }
            buffer1[1] = 0;
            nbyt = 2900;
        }
        sync = -1;
        for (j = 0; j < 10; j++)
            if (sync == -1 && (buffer1[j * 2 + 1] & 0xff) != 0x80)
                sync = j;
        if (g.get_debug() == 1)
            System.out.println("sync " + sync + " sync " + (buffer1[1] & 0xff) +
                               " nbyt " + nbyt);
        if (sync >= 0 && nbyt == nnbyt) {
            for (kn = 0; kn < nbyt / nn; kn++) {
        if (ifft % 2 == 0) {
            for (i = 0; i < blsiz; i++)
                re[i] = am[i] = wavfrm[i] = 0; // zero pad 
        }
                m = i = 0;
                avsig = 0.0;
                for (j = 0; j < nn2; j++) {
                    a = (double) (buffer1[j * 2 + nn * kn + sync * 2 + 4] & 0xff);
                    rre[j] = a;
                    avsig += a;
                }
                avsig = avsig / nn2;
                for (j = 0; j < nn2; j++) {
                    a = rre[j] - avsig;
                    wavfrm[m] = a;
                    if (ifft % 2 == 0)
                        re[m] = a;
                    else
                        am[m] = a;
                    m++;
                    if (((j + sync) % 180) == 1 && j > 1) {
                        m += 34 + (i % 2); // should be 34.5 
                        i++;
                    }
                }
                if (ifft % 2 == 1) {
                    Four(re, am, blsiz);      // do double duty with FFT
                    for (ij = 0; ij < 2; ij++) {
                        nvv++;
                        for (i = 0; i < blsiz2; i++) {
                            if (ij == 0) {
                                if (i >= 1) {
                                    rre[i] = re[i] + re[blsiz - i];
                                    aam[i] = am[i] - am[blsiz - i];
                                } else {
                                    rre[0] = re[i] + re[0];
                                    aam[0] = am[i] - am[0];
                                }
                            }
                            if (ij == 1) {
                                if (i >= 1) {
                                    aam[i] = -re[i] + re[blsiz - i];
                                    rre[i] = am[i] + am[blsiz - i];
                                } else {
                                    aam[0] = -re[i] + re[0];
                                    aam[0] = am[i] + am[0];
                                }
                            }
                            spec[i] = Math.sqrt(rre[i] * rre[i] + aam[i] * aam[i]);
                            avspec[i] += spec[i];
                            jtst[i] = 0;
                        }
                        for (j = 0; j < g.get_nbas(); j++) {
                            for (i = nstart[j]; i < nstop[j]; i++) {
                                jtst[i] = 1;
                            }
                        }
                        for (j = 0; j < nbas; j++) {
                            pmax = 0;
                            imax = 0;
                            for (i = istart; i < istop; i++) { // avoid DC - was 100 
                                if (spec[i] > pmax && jtst[i] != 0) {
                                    pmax = spec[i];
                                    imax = i;
                                }
                            }
                            jimax[j] = imax;
                            phas[j] = Math.atan2(aam[imax], rre[imax]);
                            amp[j] = spec[imax];
                            avamp[j] += amp[j];
                            if (j == 2) {
                                m = jimax[0] + jimax[1];
                                if (m < blsiz2) {
                                    if (jtst[m] != 0) {
                                        a = phas[0] + phas[1];
                                        cosa = Math.cos(a);
                                        sina = Math.sin(a);
                                        re3sum += rre[m] * cosa + aam[m] * sina;
                                        im3sum += aam[m] * cosa - rre[m] * sina;
                                        msum += m;
                                        msumsq += m * m;
                                        nvs++;
                                    }
                                }
                                m = jimax[0] - jimax[1];
                                a = phas[0] - phas[1];
                                if (m < 0) {
                                    m = -m;
                                    a = -a;
                                }
                                if (jtst[m] != 0) {
                                    cosa = Math.cos(a);
                                    sina = Math.sin(a);
                                    re3dif += rre[m] * cosa + aam[m] * sina;
                                    im3dif += aam[m] * cosa - rre[m] * sina;
                                    mdiff += m;
                                    mdiffsq += m * m;
                                    nvd++;
                                }
                            }
                            i = kk = 0;
                            for (m = 0; m < nbas; m++) {
                                if (imax >= nstart[m] && imax <= nstop[m]) {
                                    i++;
                                    kk = m;
                                }
                            }
                            if (i == 1) {
                                for (n = nstart[kk]; n < nstop[kk]; n++) {
                                    jtst[n] = 0;
                                }
                            } else {
                                for (i = -10; i <= 10; i++)
                                    if (i + imax >= 0 && i + imax < blsiz2)
                                        jtst[i + imax] = 0;
                            }
                        }
                    }
                }
               ifft++;
            }
//   System.out.println("close "+close*180.0/Math.PI+" fclose "+fclose); 
        }
    }
    if (nbas == 3) {
        a = Math.sqrt(re3sum * re3sum + im3sum * im3sum) / (nvs + 1e-6);
        b = Math.sqrt(re3dif * re3dif + im3dif * im3dif) / (nvd + 1e-6);
        amp[2] = 0;
        close = 999.0;
        msum = (msumsq * nvs - msum * msum) / (nvs * nvs + 1e-6);
        mdiff = (mdiffsq * nvd - mdiff * mdiff) / (nvd * nvd + 1e-6);
// System.out.println("msum "+msum+" mdiff "+mdiff);
        m = g.get_csum();
        if ((a > b && nvs == nvv && m == 0) || (m == 1 && msum < 10)) {
            jimax[2] = jimax[0] + jimax[1];
            amp[2] = a;
            close = -Math.atan2(im3sum, re3sum) * 180.0 / Math.PI;
        }
        if ((b >= a && nvd == nvv && m == 0) || (m == 2 && mdiff < 10)) {
            jimax[2] = jimax[1] - jimax[0];
            if (jimax[2] < 0)
                jimax[2] = -jimax[2];
            amp[2] = b;
            close = Math.atan2(im3dif, re3dif) * 180.0 / Math.PI;
        }
        for (m = 0; m < nbas; m++)
            jtst[m] = 1;
        for (m = 0; m < nbas; m++) {
            imax = blsiz2;
            i = -1;
            for (j = 0; j < nbas; j++) { // put in order of freq 
                if (jimax[j] < imax && jtst[j] != 0) {
                    imax = jimax[j];
                    i = j;
                }
            }
            if (i >= 0) {
                iord[m] = i;
                jtst[i] = 0;
            }
        }
        for (j = 0; j < nbas; j++) {
            i = iord[j];
            if (i >= 0) {
                if (i != 2)
                    a = avamp[i] / (nvv * vsc + 1e-6);
                else
                    a = amp[2] / vsc;
                g.set_vamp(a * g.get_vscale() / 1e04, j);
                g.set_vfreq(jimax[i] * 3375.0 / blsiz, j);
            }
        }
        g.set_vclos(close, 0);
    }
    g.set_vnumm(nvv);
    pmax = fmax = 0;
    imax = 0;
    for (i = istart; i < istop; i++) {
        if (avspec[i] > pmax) {
            pmax = avspec[i];
            imax = i;
            fmax = 3.375 * i / ((double) blsiz);
        }
    }
    pav = nav = 0;
    for (i = istart; i < blsiz2; i++) {
        if (i != imax) {
            pav += avspec[i];
            nav++;
        }
    }
    if (g.get_debug() == 1) {
        System.out.println("fmax " + fmax + " imax " + imax + " pmax " + pmax + " avsig " + avsig / (blsiz2));
    }
    peakfreq = fmax;
    a = 1e04 *  (nvv * vsc + 1e-6);
    peakamp = (pmax - pav / nav) * g.get_vscale() / a;
    g.set_peakfreq(peakfreq);
    g.set_peakamp(peakamp);
    if (nbas == 1) {
        g.set_vamp(peakamp, 0);
        d.dtext(8.0, ylim + 40.0, gg, Color.black, "VSRT video: " +
                " pwr: " + d.dc(peakamp, 4, 0) + " counts" + " temp: " + d.dc(peakamp, 4, 0) + "K");
    } else {
        d.dtext(8.0, ylim + 40.0, gg, Color.black, "VSRT pwr: "
                + d.dc(g.get_vamp(0), 4, 0) + "("
                + d.dc(g.get_vfreq(0), 4, 0) + ") "
                + d.dc(g.get_vamp(1), 4, 0) + "("
                + d.dc(g.get_vfreq(1), 4, 0) + ") "
                + d.dc(g.get_vamp(2), 4, 0) + "("
                + d.dc(g.get_vfreq(2), 4, 0) + ")" + " phasecl " + d.dc(g.get_vclos(0), 4, 0) + " deg");
    }

    for (j = 0; j < blsiz2; j++) {
        g.set_spec(g.get_vscale() * avspec[j] / a, j);
        g.set_wav(wavfrm[j], j);
    }
//  for(j=0;j<3;j++) System.out.println("peakamp "+g.get_peakamp()+" amp "+g.get_vamp(j)); 
}

    void Four(double fft_r[], double fft_i[], int nn) {
        int n, mmax, m, j, istep, i, ii, jj;
        double wtemp, wr, wpr, wpi, wi, theta;
        double tempr, tempi;

        n = nn << 1;
        j = 0;
        for (i = 0; i < n; i += 2) {
            if (j > i) {
                jj = j / 2;
                ii = i / 2;
                tempr = fft_r[jj];
                tempi = fft_i[jj];
                fft_r[jj] = fft_r[ii];
                fft_i[jj] = fft_i[ii];
                fft_r[ii] = tempr;
                fft_i[ii] = tempi;
            }
            m = n >> 1;
            while (m >= 2 && j >= m) {
                j -= m;
                m >>= 1;
            }
            j += m;
        }
        mmax = 2;
        while (n > mmax) {
            istep = mmax << 1;

            theta = -(6.28318530717959 / mmax);
            wtemp = Math.sin(0.5 * theta);
            wpr = -2.0 * wtemp * wtemp;
            wpi = Math.sin(theta);
            wr = 1.0;
            wi = 0.0;
            for (m = 0; m < mmax; m += 2) {
                for (i = m; i < n; i += istep) {
                    j = i + mmax;
                    jj = j / 2;
                    ii = i / 2;
                    tempr = wr * fft_r[jj] - wi * fft_i[jj];
                    tempi = wr * fft_i[jj] + wi * fft_r[jj];
                    fft_r[jj] = fft_r[ii] - tempr;
                    fft_i[jj] = fft_i[ii] - tempi;
                    fft_r[ii] += tempr;
                    fft_i[ii] += tempi;
                }
                wr = (wtemp = wr) * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
            mmax = istep;
        }

    }

}
